/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.probes;

import java.util.HashMap;
import org.nuxeo.ecm.core.management.api.AdministrativeStatus;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.Probe;
import org.nuxeo.ecm.core.management.api.ProbeStatus;
import org.nuxeo.runtime.api.Framework;

public class AdministrativeStatusProbe
implements Probe {
    @Override
    public ProbeStatus run() {
        AdministrativeStatusManager adm = (AdministrativeStatusManager)Framework.getLocalService(AdministrativeStatusManager.class);
        AdministrativeStatus status = adm.getNuxeoInstanceStatus();
        HashMap<String, String> infos = new HashMap<String, String>();
        infos.put("server", status.getInstanceIdentifier());
        infos.put("host", Framework.getProperty((String)"org.nuxeo.runtime.server.host", (String)"localhost"));
        infos.put("status", status.getState());
        if (!status.isActive()) {
            return ProbeStatus.newFailure(infos);
        }
        return ProbeStatus.newSuccess(infos);
    }
}

