/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.reporting;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.opentoutatice.ecm.reporter.Reporter;
import org.opentoutatice.ecm.reporter.config.ReporterConfigurationService;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestMode;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestModeException;
import org.opentoutatice.ecm.scanner.AbstractScanUpdater;
import org.opentoutatice.ecm.scanner.Scanner;
import org.opentoutatice.ecm.scanner.ScannerImpl;
import org.opentoutatice.ecm.scanner.config.ScannerConfigurationService;
import org.opentoutatice.ecm.scanner.directive.Directive;

public class ReportingRunner {
    private static final Log log = LogFactory.getLog(ReportingRunner.class);
    public static final String TRANSAC_TIMEOUT = "ottc.scan.transaction.timeout";
    public static final String DEFAULT_TRANSAC_TIMEOUT = "900";
    private final ScannerConfigurationService scanCfg = (ScannerConfigurationService)Framework.getService(ScannerConfigurationService.class);
    private ReporterConfigurationService reporterCfg = (ReporterConfigurationService)Framework.getService(ReporterConfigurationService.class);

    private Scanner getScanner(Event event) throws Exception {
        AbstractScanUpdater scanUpdater = this.scanCfg.getUpdater(event);
        return new ScannerImpl(scanUpdater);
    }

    private Reporter getReporter(Event event) throws InstantiationException, IllegalAccessException {
        return this.reporterCfg.getReporter(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Event event) throws Exception {
        block15: {
            TransactionHelper.commitOrRollbackTransaction();
            Integer timeout = Integer.valueOf(Framework.getProperty((String)TRANSAC_TIMEOUT, (String)DEFAULT_TRANSAC_TIMEOUT));
            TransactionHelper.startTransaction((int)timeout);
            Directive directive = this.scanCfg.getDirective(event);
            Scanner scanner = this.getScanner(event);
            Iterable<?> scannedObjects = scanner.scan(directive);
            ErrorTestMode.incrementUCErrorsIndicator();
            try {
                if (scannedObjects == null) break block15;
                AbstractScanUpdater updater = scanner.getUpdater();
                Iterator<?> iterator = scannedObjects.iterator();
                int index = 0;
                int counter = 0;
                if (log.isInfoEnabled()) {
                    log.info((Object)"== [Started] ==");
                }
                while (iterator.hasNext()) {
                    block16: {
                        Object scannedObject = iterator.next();
                        try {
                            if (!updater.acceptInNewTx(index, scannedObject)) break block16;
                            scannedObject = updater.initializeInNewTx(index, scannedObject);
                            Reporter reporter = this.getReporter(event);
                            Object report = reporter.build(index, scannedObject);
                            updater.updateInNewTx(index, scannedObject);
                            try {
                                reporter.send(report);
                            }
                            catch (MessagingException | ErrorTestModeException e) {
                                try {
                                    updater.updateOnErrorInTx(index, scannedObject);
                                }
                                catch (Exception ue) {
                                    this.logStackTrace(log, ue);
                                }
                                this.logStackTrace(log, e);
                            }
                            ++counter;
                        }
                        catch (Exception e) {
                            ++counter;
                            this.logStackTrace(log, e);
                        }
                    }
                    ++index;
                    ErrorTestMode.incrementUCErrorsIndicator();
                }
                ErrorTestMode.resetGeneratedUseCaseErrors();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[Treated objects]: " + counter + " / " + index));
                }
            }
            finally {
                if (scannedObjects != null) {
                    Class<?>[] parameterStype = null;
                    Method method = scannedObjects.getClass().getMethod("close", parameterStype);
                    if (method != null) {
                        Object[] args = null;
                        method.invoke(scannedObjects, args);
                    }
                }
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
                if (log.isInfoEnabled()) {
                    log.info((Object)"== [Ended] ==");
                }
            }
        }
    }

    private void logStackTrace(Log log, Throwable t) {
        StringWriter stringWritter = new StringWriter();
        PrintWriter printWritter = new PrintWriter((Writer)stringWritter, true);
        t.printStackTrace(printWritter);
        log.error((Object)("[ERROR]: " + stringWritter.toString()));
    }
}

