/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.scanner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestMode;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestModeException;

public abstract class AbstractScanUpdater {
    private static final Log log = LogFactory.getLog(AbstractScanUpdater.class);
    private Map<String, Serializable> cfgParams = new HashMap<String, Serializable>(0);

    public void setCfgParams(Map<String, Serializable> cfgParams) {
        this.cfgParams = cfgParams;
    }

    public Map<String, Serializable> getParams() throws Exception {
        return this.cfgParams;
    }

    public abstract Object toModel(Object var1) throws Exception;

    public boolean acceptInNewTx(int index, Object scannedObject) throws Exception {
        boolean accepted = false;
        boolean acceptedInErrTest = true;
        Transaction originateTx = TransactionHelper.requireNewTransaction();
        try {
            accepted = this.accept(index, scannedObject);
            if (accepted && ErrorTestMode.generateError(1)) {
                throw new ErrorTestModeException("Error on ScanUpdater#accept");
            }
            boolean bl = accepted;
            return bl;
        }
        catch (Exception e) {
            TransactionHelper.setTransactionRollbackOnly();
            if (ErrorTestMode.isActivated() && log.isInfoEnabled()) {
                acceptedInErrTest = false;
            }
            throw e;
        }
        finally {
            if (ErrorTestMode.isActivated() && accepted && log.isInfoEnabled()) {
                if (acceptedInErrTest) {
                    log.info((Object)"Accepted");
                } else {
                    log.info((Object)"NOT accepted");
                }
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.resumeTransaction((Transaction)originateTx);
        }
    }

    public abstract boolean accept(int var1, Object var2) throws Exception;

    public Object initializeInNewTx(int index, Object scannedObject) throws Exception {
        boolean initialized = true;
        Transaction originateTx = TransactionHelper.requireNewTransaction();
        try {
            Object initializedScanObject = this.initialize(index, scannedObject);
            if (ErrorTestMode.generateError(2)) {
                throw new ErrorTestModeException("Error on ScanUpdater#initialize");
            }
            Object object = initializedScanObject;
            return object;
        }
        catch (Exception e) {
            TransactionHelper.setTransactionRollbackOnly();
            if (ErrorTestMode.isActivated() && log.isInfoEnabled()) {
                initialized = false;
            }
            throw e;
        }
        finally {
            if (ErrorTestMode.isActivated() && log.isInfoEnabled()) {
                if (initialized) {
                    log.info((Object)"Initialized");
                } else {
                    log.info((Object)"NOT initialized");
                }
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.resumeTransaction((Transaction)originateTx);
        }
    }

    public abstract Object initialize(int var1, Object var2) throws Exception;

    public Object updateInNewTx(int index, Object scannedObject) throws Exception {
        boolean updated = true;
        Transaction originateTx = TransactionHelper.requireNewTransaction();
        try {
            Object updatedObject = this.update(index, scannedObject);
            if (ErrorTestMode.generateError(3)) {
                throw new ErrorTestModeException("Error on ScanUpdater#update");
            }
            Object object = updatedObject;
            return object;
        }
        catch (Exception e) {
            TransactionHelper.setTransactionRollbackOnly();
            if (ErrorTestMode.isActivated() && log.isInfoEnabled()) {
                updated = false;
            }
            throw e;
        }
        finally {
            if (ErrorTestMode.isActivated() && log.isInfoEnabled()) {
                if (updated) {
                    log.info((Object)"Updated");
                } else {
                    log.info((Object)"NOT updated");
                }
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.resumeTransaction((Transaction)originateTx);
        }
    }

    public abstract Object update(int var1, Object var2) throws Exception;

    public Object updateOnErrorInTx(int index, Object scannedObject) throws Exception {
        boolean updated = true;
        Transaction originateTx = TransactionHelper.requireNewTransaction();
        try {
            Object updatedObject = this.updateOnError(index, scannedObject);
            if (ErrorTestMode.generateError(5)) {
                throw new ErrorTestModeException("Error on ScanUpdater#updateOnError");
            }
            Object object = updatedObject;
            return object;
        }
        catch (Exception e) {
            TransactionHelper.setTransactionRollbackOnly();
            if (ErrorTestMode.isActivated() && log.isInfoEnabled()) {
                updated = false;
            }
            throw e;
        }
        finally {
            if (ErrorTestMode.isActivated() && log.isInfoEnabled()) {
                if (updated) {
                    log.info((Object)"Updated on mail error");
                } else {
                    log.info((Object)"NOT updated on mail error");
                }
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.resumeTransaction((Transaction)originateTx);
        }
    }

    public abstract Object updateOnError(int var1, Object var2) throws Exception;
}

