/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.scanner;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.ecm.reporting.ReportingRunner;
import org.opentoutatice.ecm.scanner.config.ScannerConfigurationService;

public class ScanningListener
implements EventListener {
    private static final Log log = LogFactory.getLog(ScanningListener.class);
    private ScannerConfigurationService configurationService;

    public void handleEvent(Event event) throws ClientException {
        if (StringUtils.equals((String)"startNewsScan", (String)event.getName())) {
            this.configurationService = (ScannerConfigurationService)Framework.getService(ScannerConfigurationService.class);
            if (this.configurationService == null) {
                log.error((Object)"No ScannerConfigurationService defined");
            } else {
                long begin = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Begin [" + event.getName() + "]"));
                }
                try {
                    ReportingRunner reporting = new ReportingRunner();
                    reporting.run(event);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    throw new ClientException((Throwable)e);
                }
                long end = System.currentTimeMillis();
                long duration = end - begin;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ended [" + event.getName() + "]: " + duration + " ms"));
                }
            }
        }
    }
}

