/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.live;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.task.live.commands.Flush;
import org.nuxeo.connect.update.task.standalone.InstallTask;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.reload.ReloadService;

public class LiveInstallTask
extends InstallTask {
    public LiveInstallTask(PackageUpdateService pus) {
        super(pus);
    }

    protected void doRun(Map<String, String> params) throws PackageException {
        super.doRun(params);
        LiveInstallTask.reloadComponents(this.getPackage());
    }

    protected void taskDone() throws PackageException {
        try {
            ((ReloadService)Framework.getLocalService(ReloadService.class)).reload();
        }
        catch (Exception e) {
            throw new PackageException("Can not relaod service", (Throwable)e);
        }
        if (this.isRestartRequired()) {
            this.service.setPackageState(this.pkg, PackageState.INSTALLED);
        } else {
            this.service.setPackageState(this.pkg, PackageState.STARTED);
        }
    }

    @Deprecated
    protected static void reloadComponents(LocalPackage localPackage) throws PackageException {
        File file = localPackage.getData().getEntry("reload");
        if (file.isFile()) {
            try {
                List lines = FileUtils.readLines((File)file);
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    LiveInstallTask.reloadComponent(line);
                }
            }
            catch (IOException e) {
                throw new PackageException("Failed to read the 'reload' file", (Throwable)e);
            }
        }
    }

    @Deprecated
    protected static void reloadComponent(String name) throws PackageException {
        try {
            RegistrationInfoImpl ri = (RegistrationInfoImpl)Framework.getRuntime().getComponentManager().getRegistrationInfo(new ComponentName(name));
            if (ri != null) {
                ri.reload();
            }
        }
        catch (Exception e) {
            throw new PackageException("Failed to reload component: " + name, (Throwable)e);
        }
    }

    protected void flush() throws PackageException {
        Flush.flush();
    }
}

