/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.Logo;
import org.nuxeo.theme.styling.service.descriptors.PalettePreview;

@XObject(value="flavor")
public class Flavor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    String name;
    @XNode(value="label")
    String label;
    @XNode(value="@extends")
    String extendsFlavor;
    @XNode(value="logo")
    Logo logo;
    @XNode(value="palettePreview")
    PalettePreview palettePreview;
    @XNode(value="presetsList@append")
    boolean appendPresets;
    @XNodeList(value="presetsList/presets", type=ArrayList.class, componentType=FlavorPresets.class)
    List<FlavorPresets> presets;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getExtendsFlavor() {
        return this.extendsFlavor;
    }

    public void setExtendsFlavor(String extendsFlavor) {
        this.extendsFlavor = extendsFlavor;
    }

    public boolean getAppendPresets() {
        return this.appendPresets;
    }

    public List<FlavorPresets> getPresets() {
        return this.presets;
    }

    public void setPresets(List<FlavorPresets> presets) {
        this.presets = presets;
    }

    public Logo getLogo() {
        return this.logo;
    }

    public void setLogo(Logo logo) {
        this.logo = logo;
    }

    public void setAppendPresets(boolean appendPresets) {
        this.appendPresets = appendPresets;
    }

    public PalettePreview getPalettePreview() {
        return this.palettePreview;
    }

    public void setPalettePreview(PalettePreview palettePreview) {
        this.palettePreview = palettePreview;
    }

    public Flavor clone() {
        PalettePreview pp;
        Flavor clone = new Flavor();
        clone.setName(this.getName());
        clone.setLabel(this.getLabel());
        Logo logo = this.getLogo();
        if (logo != null) {
            clone.setLogo(logo.clone());
        }
        if ((pp = this.getPalettePreview()) != null) {
            clone.setPalettePreview(pp.clone());
        }
        clone.setExtendsFlavor(this.getExtendsFlavor());
        clone.setAppendPresets(this.getAppendPresets());
        List<FlavorPresets> presets = this.getPresets();
        if (presets != null) {
            ArrayList<FlavorPresets> newPresets = new ArrayList<FlavorPresets>();
            for (FlavorPresets item : presets) {
                newPresets.add(item.clone());
            }
            clone.setPresets(newPresets);
        }
        return clone;
    }
}

