/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.identity;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.identity.Base64;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;

public class SecurityHeaderGenerator {
    public static final String HASH_METHOD = "MD5";

    public static Map<String, String> getHeaders() throws ConnectSecurityError {
        Map<String, String> headers = LogicalInstanceIdentifier.isRegistered() ? SecurityHeaderGenerator.getRegisteredHeaders() : SecurityHeaderGenerator.getAnonymousHeaders();
        return headers;
    }

    public static Map<String, String> getRegisteredHeaders(LogicalInstanceIdentifier logicalIdentifier, TechnicalInstanceIdentifier technicalIdentifier) throws ConnectSecurityError {
        String digest;
        String TS;
        String CTID;
        String CLID1;
        Map<String, String> headers = SecurityHeaderGenerator.getAnonymousHeaders();
        try {
            CLID1 = logicalIdentifier.getCLID1();
            String CLID2 = logicalIdentifier.getCLID2();
            CTID = technicalIdentifier.getCTID();
            TS = "" + System.currentTimeMillis();
            String toDigest = CLID2 + CTID + TS;
            digest = Base64.encodeBytes(MessageDigest.getInstance(HASH_METHOD).digest(toDigest.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectSecurityError("Unable to construct Security Headers", e);
        }
        headers.put("X-NUXEO-CONNECT-CLID", CLID1);
        headers.put("X-NUXEO-CONNECT-CTID", CTID);
        headers.put("X-NUXEO-CONNECT-TS", TS);
        headers.put("X-NUXEO-CONNECT-DIGEST", digest);
        headers.put("X-NUXEO-CONNECT-DIGEST-METHOD", HASH_METHOD);
        return headers;
    }

    protected static Map<String, String> getRegisteredHeaders() throws ConnectSecurityError {
        try {
            return SecurityHeaderGenerator.getRegisteredHeaders(LogicalInstanceIdentifier.instance(), TechnicalInstanceIdentifier.instance());
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            throw new ConnectSecurityError("Unable to construct Security Headers", e);
        }
    }

    public static Map<String, String> getAnonymousHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-NUXEO-CONNECT-CLIENT-VERSION", NuxeoConnectClient.getVersion());
        return headers;
    }
}

