/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.packages.AbstractPackageSource;
import org.nuxeo.connect.packages.PackageSource;

public class DownloadingPackageSource
extends AbstractPackageSource
implements PackageSource {
    protected static final Log log = LogFactory.getLog(DownloadingPackageSource.class);

    public DownloadingPackageSource() {
        this.id = "downloading";
        this.name = "Downloading";
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        result.addAll(cdm.listDownloadingPackages());
        return result;
    }

    @Override
    public DownloadablePackage getPackageById(String packageId) {
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        DownloadingPackage pkg = cdm.getDownloadingPackage(packageId);
        return pkg;
    }
}

