/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.jdbc.SimonResultSet;
import org.javasimon.jdbc.SqlNormalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimonStatement
implements Statement {
    protected final List<String> batchSql = new LinkedList<String>();
    protected Connection conn;
    protected String prefix;
    protected String sqlCmdLabel;
    protected SqlNormalizer sqlNormalizer;
    protected Split split;
    private Statement stmt;

    SimonStatement(Connection conn, Statement stmt, String prefix) {
        this.conn = conn;
        this.stmt = stmt;
        this.prefix = prefix;
        this.split = SimonManager.getStopwatch((String)(prefix + ".stmt")).start();
    }

    @Override
    public final void close() throws SQLException {
        this.stmt.close();
        this.split.stop();
    }

    @Override
    public final Connection getConnection() {
        return this.conn;
    }

    protected final Split prepare(String sql) {
        if (sql != null && !sql.equals("")) {
            this.sqlNormalizer = new SqlNormalizer(sql);
            this.sqlCmdLabel = this.prefix + ".sql." + this.sqlNormalizer.getType();
            return this.startSplit();
        }
        return null;
    }

    protected final Split prepare(List<String> sqls) {
        if (!sqls.isEmpty()) {
            this.sqlNormalizer = sqls.size() == 1 ? new SqlNormalizer(sqls.get(0)) : new SqlNormalizer(sqls);
            this.sqlCmdLabel = this.prefix + ".sql." + this.sqlNormalizer.getType();
            return this.startSplit();
        }
        return null;
    }

    protected Split startSplit() {
        Stopwatch stopwatch = SimonManager.getStopwatch((String)(this.sqlCmdLabel + "." + this.sqlNormalizer.getNormalizedSql().hashCode()));
        if (stopwatch.getNote() == null) {
            stopwatch.setNote(this.sqlNormalizer.getNormalizedSql());
        }
        return stopwatch.start();
    }

    protected final void finish(Split split) {
        if (split != null) {
            SimonManager.getStopwatch((String)this.sqlCmdLabel).addTime(split.stop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        Split s = this.prepare(sql);
        try {
            SimonResultSet simonResultSet = new SimonResultSet(this.stmt.executeQuery(sql), this, this.prefix, s.getStopwatch().getName());
            return simonResultSet;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int executeUpdate(String sql) throws SQLException {
        Split s = this.prepare(sql);
        try {
            int n = this.stmt.executeUpdate(sql);
            return n;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Split s = this.prepare(sql);
        try {
            int n = this.stmt.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Split s = this.prepare(sql);
        try {
            int n = this.stmt.executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Split s = this.prepare(sql);
        try {
            int n = this.stmt.executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean execute(String sql) throws SQLException {
        Split s = this.prepare(sql);
        try {
            boolean bl = this.stmt.execute(sql);
            return bl;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        Split s = this.prepare(sql);
        try {
            boolean bl = this.stmt.execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        Split s = this.prepare(sql);
        try {
            boolean bl = this.stmt.execute(sql, columnIndexes);
            return bl;
        }
        finally {
            this.finish(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        Split s = this.prepare(sql);
        try {
            boolean bl = this.stmt.execute(sql, columnNames);
            return bl;
        }
        finally {
            this.finish(s);
        }
    }

    @Override
    public final void addBatch(String s) throws SQLException {
        this.batchSql.add(s);
        this.stmt.addBatch(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        Split s = this.prepare(this.batchSql);
        try {
            int[] nArray = this.stmt.executeBatch();
            return nArray;
        }
        finally {
            this.finish(s);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchSql.clear();
        this.stmt.clearBatch();
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(int i) throws SQLException {
        this.stmt.setMaxFieldSize(i);
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    @Override
    public final void setMaxRows(int i) throws SQLException {
        this.stmt.setMaxRows(i);
    }

    @Override
    public final void setEscapeProcessing(boolean b) throws SQLException {
        this.stmt.setEscapeProcessing(b);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int i) throws SQLException {
        this.stmt.setQueryTimeout(i);
    }

    @Override
    public final void cancel() throws SQLException {
        this.stmt.cancel();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    @Override
    public final void setCursorName(String s) throws SQLException {
        this.stmt.setCursorName(s);
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return this.stmt.getResultSet();
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    @Override
    public final void setFetchDirection(int i) throws SQLException {
        this.stmt.setFetchDirection(i);
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public final void setFetchSize(int i) throws SQLException {
        this.stmt.setFetchSize(i);
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public final boolean getMoreResults(int i) throws SQLException {
        return this.stmt.getMoreResults(i);
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }
}

