/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSNamespaceRule
implements ICSSWriteable {
    private String m_sPrefix;
    private String m_sURL;

    public CSSNamespaceRule(@Nullable String string, @Nonnull String string2) {
        this.setNamespacePrefix(string);
        this.setNamespaceURL(string2);
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.m_sPrefix;
    }

    public void setNamespacePrefix(@Nullable String string) {
        this.m_sPrefix = string;
    }

    @Nonnull
    public String getNamespaceURL() {
        return this.m_sURL;
    }

    public void setNamespaceURL(@Nonnull String string) {
        if (string == null) {
            throw new NullPointerException("URL");
        }
        this.m_sURL = string;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteNamespaceRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@namespace ");
        if (StringHelper.hasText((CharSequence)this.m_sPrefix)) {
            stringBuilder.append(this.m_sPrefix).append(' ');
        }
        return stringBuilder.append(this.m_sURL).append(";\n").toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSNamespaceRule)) {
            return false;
        }
        CSSNamespaceRule cSSNamespaceRule = (CSSNamespaceRule)object;
        return EqualsUtils.equals((Object)this.m_sPrefix, (Object)cSSNamespaceRule.m_sPrefix) && this.m_sURL.equals(cSSNamespaceRule.m_sURL);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPrefix).append((Object)this.m_sURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("prefix", (Object)this.m_sPrefix).append("URL", (Object)this.m_sURL).toString();
    }
}

