/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.propertyvalue;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.ICSSMultiValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CSSValueList
implements ICSSMultiValue {
    private final List<CSSValue> m_aValues;

    public CSSValueList(@Nonnull ICSSProperty[] iCSSPropertyArray, @Nonnull String[] stringArray, boolean bl) {
        if (ArrayHelper.isEmpty((Object[])iCSSPropertyArray)) {
            throw new IllegalArgumentException("No properties passed!");
        }
        if (ArrayHelper.isEmpty((Object[])stringArray)) {
            throw new IllegalArgumentException("No value passed!");
        }
        if (iCSSPropertyArray.length != stringArray.length) {
            throw new IllegalArgumentException("Different number of properties and values passed");
        }
        this.m_aValues = new ArrayList<CSSValue>(iCSSPropertyArray.length);
        for (int i = 0; i < iCSSPropertyArray.length; ++i) {
            this.m_aValues.add(new CSSValue(iCSSPropertyArray[i], stringArray[i], bl));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSValue> getContainedValues() {
        return ContainerHelper.newList(this.m_aValues);
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        if (this.m_aValues.isEmpty()) {
            throw new IllegalStateException("No value present to determine the property from!");
        }
        return ((CSSValue)ContainerHelper.getLastElement(this.m_aValues)).getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CSSValue cSSValue : this.m_aValues) {
            stringBuilder.append(cSSValue.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSValueList)) {
            return false;
        }
        CSSValueList cSSValueList = (CSSValueList)object;
        return ((Object)this.m_aValues).equals(cSSValueList.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).toString();
    }
}

