/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.tools;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.reader.CSSReader;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MediaQueryTools {
    private MediaQueryTools() {
    }

    @Nullable
    public static List<CSSMediaQuery> parseToMediaQuery(@Nullable String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        if (StringHelper.hasNoText((CharSequence)string)) {
            return null;
        }
        String string2 = "@media " + string + " {}";
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string2, charset, eCSSVersion);
        if (cascadingStyleSheet == null) {
            return null;
        }
        CSSMediaRule cSSMediaRule = cascadingStyleSheet.getAllMediaRules().get(0);
        return cSSMediaRule.getAllMediaQueries();
    }

    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet cascadingStyleSheet) {
        return cascadingStyleSheet != null && !cascadingStyleSheet.hasMediaRules();
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull CSSMediaQuery cSSMediaQuery) {
        return MediaQueryTools.getWrappedInMediaQuery(cascadingStyleSheet, ContainerHelper.newList((Object)cSSMediaQuery));
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @Nonempty List<CSSMediaQuery> list) {
        if (cascadingStyleSheet == null) {
            throw new NullPointerException("CSS");
        }
        if (ContainerHelper.isEmpty(list)) {
            throw new IllegalArgumentException("no mediaQueries present");
        }
        if (!MediaQueryTools.canWrapInMediaQuery(cascadingStyleSheet)) {
            return null;
        }
        CascadingStyleSheet cascadingStyleSheet2 = new CascadingStyleSheet();
        for (CSSImportRule object : cascadingStyleSheet.getAllImportRules()) {
            if (object.hasMediaQueries()) {
                cascadingStyleSheet2.addImportRule(object);
                continue;
            }
            CSSImportRule cSSImportRule = new CSSImportRule(object.getLocation());
            for (CSSMediaQuery cSSMediaQuery : list) {
                cSSImportRule.addMediaQuery(cSSMediaQuery);
            }
            cascadingStyleSheet2.addImportRule(cSSImportRule);
        }
        for (CSSNamespaceRule cSSNamespaceRule : cascadingStyleSheet.getAllNamespaceRules()) {
            cascadingStyleSheet2.addNamespaceRule(cSSNamespaceRule);
        }
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        for (CSSMediaQuery cSSMediaQuery : list) {
            cSSMediaRule.addMediaQuery(cSSMediaQuery);
        }
        for (ICSSTopLevelRule iCSSTopLevelRule : cascadingStyleSheet.getAllRules()) {
            cSSMediaRule.addRule(iCSSTopLevelRule);
        }
        cascadingStyleSheet2.addRule(cSSMediaRule);
        return cascadingStyleSheet2;
    }
}

