/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.feature.news.mail;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.util.DateUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.ecm.feature.news.model.SpaceMember;
import org.opentoutatice.ecm.reporter.AbstractMailer;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestMode;
import org.opentoutatice.ecm.reporting.test.mode.ErrorTestModeException;

public class NewsMailer
extends AbstractMailer {
    private static final Log log = LogFactory.getLog(NewsMailer.class);
    private static final String MODIFIED_DOCS_QUERY = "select * from Note, File, Picture, ContextualLink, ToutaticePad where ecm:ancestorId = '%s'  and dc:modified > TIMESTAMP '%s' and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted' order by dc:modified desc";
    private static final String NEW_MEMBERS_QUERY = "select distinct ttcs:spaceMembers/*1/login from Workspace  where ecm:uuid = '%s' and ttcs:spaceMembers/*1/joinedDate > TIMESTAMP '%s' and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted'";
    private static final String NEWS_DOCS_QUERY = "select * from Annonce, VEVENT where ecm:ancestorId = '%s'  and dc:modified > TIMESTAMP '%s' and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted' order by dc:modified desc";
    private static final int MAX_DISPLAYED = 10;
    private static final String PORTAL_URL = Framework.getProperty((String)"ottc.news.portal.url");
    private static final String EVENT_DATE_FORMAT = "dd/MM/yyyy";
    private static final String EVENT_TIME_FORMAT = "HH:mm ";
    private boolean sends = true;
    private Map<String, Object> header;
    private Map<String, Object> news;
    private Map<String, Object> activities;

    public Object adapt(Object inputData) throws Exception {
        return inputData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object build(int index, Object data) throws Exception {
        CoreSession session;
        if (ErrorTestMode.generateError((int)6)) {
            throw new ErrorTestModeException("Error on NewsMailer#build");
        }
        SpaceMember member = (SpaceMember)data;
        this.setData(new HashMap(1));
        try {
            session = member.getSession();
            String spaceId = member.getSpaceId();
            Date lastNewsDate = member.getLastNewsDate();
            DocumentModelList modifiedDocs = this.getModifiedDocs(member.getSession(), spaceId, lastNewsDate);
            this.setActivities(member.getLogin(), modifiedDocs);
            if (log.isDebugEnabled() && modifiedDocs != null) {
                DocumentModel space = ToutaticeDocumentHelper.getUnrestrictedDocument((CoreSession)session, (String)member.getSpaceId());
                log.debug((Object)("[" + space.getTitle() + " : " + session.getPrincipal().getName() + "] [Last Notif: " + DateFormatUtils.format((Date)lastNewsDate, (String)"dd-MM-yyyy HH:mm") + "]"));
                log.debug((Object)("[" + modifiedDocs.size() + "] MODIFIED DOCS"));
                for (DocumentModel doc : modifiedDocs) {
                    log.debug((Object)(doc.getTitle() + " ; "));
                }
            }
            try (IterableQueryResult newMembers = null;){
                newMembers = this.getNewMembers(session, spaceId, lastNewsDate);
                int newMembersCount = this.excludeHimSelf(member.getLogin(), newMembers);
                DocumentModelList newsDocs = this.getNewsDocs(session, spaceId, lastNewsDate);
                this.setNews(member.getLogin(), newMembersCount, newsDocs);
                if (log.isDebugEnabled() && newsDocs != null) {
                    DocumentModel space = ToutaticeDocumentHelper.getUnrestrictedDocument((CoreSession)session, (String)member.getSpaceId());
                    log.debug((Object)("[" + space.getTitle() + " : " + session.getPrincipal().getName() + "] [Last Notif: " + DateFormatUtils.format((Date)lastNewsDate, (String)"dd-MM-yyyy HH:mm") + "]"));
                    log.debug((Object)("[" + newsDocs.size() + "] NEWS"));
                    for (DocumentModel doc : newsDocs) {
                        log.debug((Object)(doc.getTitle() + " ; "));
                    }
                }
                if (log.isDebugEnabled() && newMembers != null) {
                    log.debug((Object)("[" + newMembers.size() + "] new members"));
                }
            }
            this.setMailHeader(member);
        }
        finally {
            session = member.getSession();
            if (session != null) {
                session.save();
                session.close();
            }
        }
        return this.getData();
    }

    public void setMailHeader(SpaceMember member) throws Exception {
        this.header = new HashMap<String, Object>();
        this.header.put("mail.to", member.getEmail());
        this.header.put("subjectTemplate", "ottcNewsSubject");
        this.header.put("template", "ottcNews");
        this.header.put("spaceTitle", member.getSpaceTitle());
        this.header.put("sendDate", DateUtils.format((Date)new Date(), (String)EVENT_DATE_FORMAT));
        this.header.put("lastSendDate", DateUtils.format((Date)member.getLastNewsDate(), (String)EVENT_DATE_FORMAT));
        this.getData().putAll(this.header);
    }

    public void setNews(String currentLogin, long newMembersCount, DocumentModelList docs) {
        this.news = new HashMap<String, Object>();
        boolean display = false;
        this.news.put("newMembersCount", newMembersCount);
        if (newMembersCount > 0L) {
            display = true;
        }
        int maxLoops = docs.size() > 0 && docs.size() > 10 ? 10 : docs.size();
        int otherDocsCount = 0 < maxLoops && docs.size() < maxLoops ? 0 : docs.size() - maxLoops;
        this.news.put("otherDocsCount", otherDocsCount);
        ArrayList<Map<String, Object>> newsList = new ArrayList<Map<String, Object>>(maxLoops);
        for (int index = 0; index < maxLoops; ++index) {
            DocumentModel doc = (DocumentModel)docs.get(index);
            Map<String, Object> news = this.buildUnitData(currentLogin, doc);
            if (news.isEmpty()) continue;
            newsList.add(news);
        }
        this.news.put("docs", newsList);
        display = newsList.size() > 0 || newMembersCount > 0L;
        this.news.put("display", display);
        this.sends = this.sends || display;
        this.getData().put("news", this.news);
    }

    public void setActivities(String currentLogin, DocumentModelList docs) {
        this.activities = new HashMap<String, Object>();
        int maxLoops = docs.size() > 0 && docs.size() > 10 ? 10 : docs.size();
        int otherDocsCount = 0 < maxLoops && docs.size() < maxLoops ? 0 : docs.size() - maxLoops;
        this.activities.put("otherDocsCount", otherDocsCount);
        ArrayList<Map<String, Object>> activities = new ArrayList<Map<String, Object>>(maxLoops);
        for (int index = 0; index < maxLoops; ++index) {
            DocumentModel doc = (DocumentModel)docs.get(index);
            Map<String, Object> activity = this.buildUnitData(currentLogin, doc);
            if (activity.isEmpty()) continue;
            activities.add(activity);
        }
        this.activities.put("docs", activities);
        boolean display = activities.size() > 0;
        this.activities.put("display", display);
        this.sends = display;
        this.getData().put("activities", this.activities);
    }

    public Map<String, Object> buildUnitData(String currentLogin, DocumentModel doc) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        String lastContributor = (String)((Object)doc.getPropertyValue("dc:lastContributor"));
        if (!StringUtils.equals((String)currentLogin, (String)lastContributor)) {
            data.put("doc", doc);
            data.put("title", doc.getTitle());
            data.put("link", this.getPortalLink(doc));
            GregorianCalendar calendar = (GregorianCalendar)doc.getPropertyValue("dc:modified");
            data.put("modified", DateUtils.format((Date)calendar.getTime(), (String)EVENT_DATE_FORMAT));
            data.put("lastContributor", this.getDisplayedName(lastContributor));
            if ("VEVENT".equals(doc.getType())) {
                GregorianCalendar evtCal = (GregorianCalendar)doc.getPropertyValue("vevent:dtstart");
                data.put("evtBegin", "le " + DateFormatUtils.format((Date)evtCal.getTime(), (String)EVENT_DATE_FORMAT) + " \u00e0 " + DateFormatUtils.format((Date)evtCal.getTime(), (String)EVENT_TIME_FORMAT));
            }
        }
        return data;
    }

    protected DocumentModelList getModifiedDocs(CoreSession session, String wsId, Date lastNewsDate) {
        String formatedDate = DateFormatUtils.format((Date)lastNewsDate, (String)"yyyy-MM-dd HH:mm:ss");
        String query = String.format(MODIFIED_DOCS_QUERY, wsId, formatedDate);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifieds docs query: " + query));
        }
        return session.query(query);
    }

    protected IterableQueryResult getNewMembers(CoreSession session, String wsId, Date lastNewsDate) {
        String formatedDate = DateFormatUtils.format((Date)lastNewsDate, (String)"yyyy-MM-dd HH:mm:ss");
        String query = String.format(NEW_MEMBERS_QUERY, wsId, formatedDate);
        return session.queryAndFetch(query, "NXQL", new Object[0]);
    }

    protected DocumentModelList getNewsDocs(CoreSession session, String wsId, Date lastNewsDate) {
        String formatedDate = DateFormatUtils.format((Date)lastNewsDate, (String)"yyyy-MM-dd HH:mm:ss");
        String query = String.format(NEWS_DOCS_QUERY, wsId, formatedDate);
        if (log.isDebugEnabled()) {
            log.debug((Object)("News docs query: " + query));
        }
        return session.query(query);
    }

    protected int excludeHimSelf(String currentLogin, IterableQueryResult newMembers) {
        int newMembersCount = 0;
        if (newMembers != null) {
            Iterator iterator = newMembers.iterator();
            while (iterator.hasNext()) {
                String login = (String)((Map)iterator.next()).get("ttcs:spaceMembers/*1/login");
                if (StringUtils.equals((String)currentLogin, (String)login)) continue;
                ++newMembersCount;
            }
        }
        return newMembersCount;
    }

    protected String getDisplayedName(String login) {
        String dName = "";
        NuxeoPrincipal principal = SpaceMember.getUsermanager().getPrincipal(login);
        if (principal != null) {
            dName = principal.getFirstName() + " " + principal.getLastName();
        }
        return dName;
    }

    protected String getPortalLink(DocumentModel doc) {
        String id = (String)((Object)doc.getPropertyValue("ttc:webid"));
        return PORTAL_URL + id;
    }

    public void send(Object content) throws MessagingException, ErrorTestModeException {
        if (ErrorTestMode.isActivated()) {
            this.sends = true;
        }
        if (this.sends) {
            super.send(content);
        }
    }
}

