/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.feature.news.scanner;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.ecm.feature.news.scanner.io.NewsPeriod;

public class DateUpdaterTools {
    private static final Log log = LogFactory.getLog(DateUpdaterTools.class);
    public static final String DATE_TIME_FORMAT = "dd-MM-yyyy HH:mm";
    public static final String DATE_TIME_QUERY_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String NEXT_DAILY_BOUNDARY = "nextDailyBoundary";
    public static final String NEXT_WEEKLY_BOUNDARY = "nextWeeklyBoundary";
    public static final String NEXT_ERROR_BOUNDARY = "nextErrorBoundary";

    private DateUpdaterTools() {
    }

    public static Date computeNextDate(NewsPeriod newsPeriod, Date inputDate, int boundary, boolean init) {
        Date nextDate = null;
        switch (newsPeriod) {
            case daily: {
                Date addedDayDate = DateUpdaterTools.setMidnight(inputDate, boundary);
                addedDayDate = DateUtils.addDays((Date)addedDayDate, (int)1);
                nextDate = DateUpdaterTools.getNextRandomDate(addedDayDate, boundary);
                break;
            }
            case weekly: {
                Date addedWeekDate = DateUpdaterTools.setMidnight(inputDate, boundary);
                addedWeekDate = DateUpdaterTools.getNextMonday(addedWeekDate);
                nextDate = DateUpdaterTools.getNextRandomDate(addedWeekDate, boundary);
                break;
            }
            case none: {
                break;
            }
            case error: {
                nextDate = DateUtils.addHours((Date)inputDate, (int)2);
            }
        }
        return nextDate;
    }

    public static Date getNextMonday(Date inputDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(inputDate);
        int currentDay = calendar.get(7);
        int shiftNextSunday = currentDay != 2 ? 9 - currentDay : 7;
        return DateUtils.addDays((Date)inputDate, (int)shiftNextSunday);
    }

    public static Date getNextTestRandomDate(Date inputDate) {
        int gap = Integer.valueOf(Framework.getProperty((String)"ottc.news.scan.dev.gap", (String)"2"));
        return DateUtils.addMinutes((Date)inputDate, (int)gap);
    }

    public static Date getNextRandomDate(Date inputDate, int boundary) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(inputDate);
        int shift = ThreadLocalRandom.current().nextInt(-1 * boundary, boundary);
        calendar.set(12, shift);
        return calendar.getTime();
    }

    public static Date setMidnight(Date date, int boundary) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(7);
        int minutes = calendar.get(12);
        calendar.set(12, minutes + boundary);
        if (day != calendar.get(7)) {
            calendar.setTime(DateUtils.addDays((Date)date, (int)1));
        } else {
            calendar.set(12, minutes);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date setMidnight(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }
}

