/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetReferenceDescriptor;

@XObject(value="row")
public class LayoutRowDescriptor {
    @XNode(value="@name")
    String name;
    @XNode(value="@selectedByDefault")
    boolean selectedByDefault = true;
    @XNode(value="@alwaysSelected")
    boolean alwaysSelected = false;
    @XNodeList(value="widget", type=WidgetReferenceDescriptor[].class, componentType=WidgetReferenceDescriptor.class)
    WidgetReferenceDescriptor[] widgets = new WidgetReferenceDescriptor[0];
    @XNodeMap(value="properties", key="@mode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> properties = new HashMap<String, PropertiesDescriptor>();

    public String getName() {
        return this.name;
    }

    public boolean isSelectedByDefault() {
        return this.selectedByDefault;
    }

    public boolean isAlwaysSelected() {
        return this.alwaysSelected;
    }

    public int getSize() {
        return this.widgets.length;
    }

    public String[] getWidgets() {
        String[] names = new String[this.widgets.length];
        for (int i = 0; i < this.widgets.length; ++i) {
            names[i] = this.widgets[i].getName();
        }
        return names;
    }

    public Map<String, Serializable> getProperties(String layoutMode) {
        return WidgetDescriptor.getProperties(this.properties, layoutMode);
    }

    public Map<String, Map<String, Serializable>> getProperties() {
        return WidgetDescriptor.getProperties(this.properties);
    }

    public LayoutRowDefinition getLayoutRowDefinition() {
        WidgetReference[] cwidgets = null;
        if (this.widgets != null) {
            cwidgets = new WidgetReference[this.widgets.length];
            for (int i = 0; i < this.widgets.length; ++i) {
                cwidgets[i] = this.widgets[i].getWidgetReference();
            }
        }
        LayoutRowDefinitionImpl clone = new LayoutRowDefinitionImpl(this.name, this.getProperties(), cwidgets, this.alwaysSelected, this.selectedByDefault);
        return clone;
    }
}

