/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.components;

import fr.toutatice.ecm.platform.core.components.ToutaticeAbstractServiceHandler;
import fr.toutatice.ecm.platform.core.components.ToutaticeServiceHandlerException;
import fr.toutatice.ecm.platform.core.components.ToutaticeServiceProvider;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;

public class ToutaticeEventFilterHandler<T>
extends ToutaticeAbstractServiceHandler<T> {
    protected Method[] handledMethods;
    protected static final String HANDLED_METHOD_NAME = "fireEvent";
    private boolean methodsError = false;
    private boolean yetInLogs = false;

    @Override
    public T newProxy(T eventService, Class<T> eventServiceKlass) {
        this.setObject(eventService);
        this.getHandledMethods(eventServiceKlass);
        return eventServiceKlass.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{eventServiceKlass}, (InvocationHandler)this));
    }

    protected void getHandledMethods(Class<T> eventServiceKlass) {
        try {
            Method secondFireEvent;
            Method firstFireEvent;
            this.handledMethods = new Method[2];
            this.handledMethods[0] = firstFireEvent = eventServiceKlass.getMethod(HANDLED_METHOD_NAME, Event.class);
            this.handledMethods[1] = secondFireEvent = eventServiceKlass.getMethod(HANDLED_METHOD_NAME, String.class, EventContext.class);
        }
        catch (Exception e) {
            this.methodsError = true;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (HANDLED_METHOD_NAME.equals(method.getName())) {
                if (this.methodsError && !this.yetInLogs) {
                    this.yetInLogs = true;
                    StringBuilder msgBuilder = new StringBuilder().append(this.object.getClass().getName()).append(" class has no '").append(HANDLED_METHOD_NAME).append("' method with given signatures");
                    throw new ToutaticeServiceHandlerException(msgBuilder.toString());
                }
                if (this.handledMethods != null && this.handledMethods.length > 0 && null != args && args.length > 0) {
                    CoreSession session = null;
                    EventContext evtCtx = null;
                    String evtName = null;
                    if (this.handledMethods[0] != null && this.handledMethods[0].equals(method)) {
                        Event evt = (Event)args[0];
                        evtName = evt.getName();
                        evtCtx = evt.getContext();
                        if (evtCtx instanceof DocumentEventContext) {
                            session = ((DocumentEventContext)evtCtx).getCoreSession();
                        }
                    } else if (this.handledMethods[1] != null && this.handledMethods[1].equals(method)) {
                        evtName = (String)args[0];
                        evtCtx = (EventContext)args[1];
                        if (evtCtx instanceof DocumentEventContext) {
                            session = ((DocumentEventContext)evtCtx).getCoreSession();
                        }
                    }
                    if (session != null && ToutaticeServiceProvider.instance().isRegistered(EventService.class, session.getSessionId())) {
                        evtCtx.setProperty("originalEventName", (Serializable)((Object)evtName));
                        EventImpl event = new EventImpl("toutaticeElasticSearchDocumentIndexation", evtCtx);
                        ((EventService)this.object).fireEvent((Event)event);
                        return null;
                    }
                }
            }
            return method.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

