/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeNotifyEventHelper {
    private static EventProducer eventProducer;
    private static Logs logsBean;

    private ToutaticeNotifyEventHelper() {
    }

    public static void notifyEvent(CoreSession session, String eventName, DocumentModel document, Map<String, Serializable> properties) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, document);
        if (null != properties) {
            for (String property : properties.keySet()) {
                ctx.setProperty(property, properties.get(property));
            }
        }
        ToutaticeNotifyEventHelper.getEventProducer().fireEvent(ctx.newEvent(eventName));
    }

    public static void notifyAuditEvent(CoreSession session, String eventName, DocumentModel document, String comment) throws ClientException {
        ToutaticeNotifyEventHelper.notifyAuditEvent(session, null, eventName, document, comment);
    }

    public static void notifyAuditEvent(CoreSession session, String category, String eventName, DocumentModel document, String comment) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, document);
        ToutaticeNotifyEventHelper.notifyAuditEvent((EventContext)ctx, null, eventName, comment);
    }

    public static void notifyAuditEvent(EventContext ctx, String category, String eventName, String comment) throws ClientException {
        ctx.setProperty("category", (Serializable)((Object)category));
        ctx.setProperty("comment", (Serializable)((Object)comment));
        Logs auditProducer = ToutaticeNotifyEventHelper.getAuditEventProducer();
        EventImpl entry = new EventImpl(eventName, ctx);
        auditProducer.logEvent((Event)entry);
    }

    private static EventProducer getEventProducer() throws ClientException {
        try {
            if (eventProducer == null) {
                eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            }
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return eventProducer;
    }

    private static Logs getAuditEventProducer() throws ClientException {
        try {
            if (logsBean == null) {
                logsBean = (Logs)Framework.getService(Logs.class);
            }
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return logsBean;
    }
}

