/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import java.io.Serializable;
import java.util.ArrayList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ToutaticeDeleteEventListener
implements EventListener {
    private static String CST_QUERY_DOCUMENT_HAVING_A_SECTION_REFERENCE = "SELECT * FROM Document WHERE ecm:mixinType = 'Folderish' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0 AND publish:sections IN ('%s')";

    public void handleEvent(Event event) throws ClientException {
        block4: {
            DocumentModelList proxies;
            CoreSession session;
            DocumentModel document;
            block5: {
                if (!(event.getContext() instanceof DocumentEventContext)) break block4;
                EventContext ctx = event.getContext();
                DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
                document = docCtx.getSourceDocument();
                session = ctx.getCoreSession();
                if (!"Section".equals(document.getType())) break block5;
                DocumentModelList list = session.query(String.format(CST_QUERY_DOCUMENT_HAVING_A_SECTION_REFERENCE, document.getId()));
                for (DocumentModel docToUpdate : list) {
                    if (!session.hasPermission(docToUpdate.getRef(), "Write")) continue;
                    String[] currentSectionIdsList = (String[])docToUpdate.getPropertyValue("publish:sections");
                    ArrayList<String> newSectionIdsList = new ArrayList<String>();
                    if (currentSectionIdsList != null) {
                        for (String sectionId : currentSectionIdsList) {
                            if (sectionId.equals(document.getId())) continue;
                            newSectionIdsList.add(sectionId);
                        }
                    }
                    docToUpdate.setPropertyValue("publish:sections", (Serializable)newSectionIdsList.toArray(new String[newSectionIdsList.size()]));
                    session.saveDocument(docToUpdate);
                }
                break block4;
            }
            if (document.isProxy() || document.isVersion() || null == (proxies = session.getProxies(document.getRef(), document.getParentRef())) || proxies.isEmpty()) break block4;
            for (DocumentModel proxy : proxies) {
                session.removeDocument(proxy.getRef());
            }
        }
    }
}

