/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.persistence;

import java.io.IOException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeDocumentModelWriter
extends DocumentModelWriter {
    private static final Log log = LogFactory.getLog(ToutaticeDocumentModelWriter.class);

    public ToutaticeDocumentModelWriter(CoreSession session, String parentPath) {
        super(session, parentPath);
    }

    public ToutaticeDocumentModelWriter(CoreSession session, String parentPath, int saveInterval) {
        super(session, parentPath, saveInterval);
    }

    public DocumentTranslationMap write(ExportedDocument xdoc) throws IOException {
        DocumentTranslationMap dtm;
        block4: {
            dtm = super.write(xdoc);
            Boolean compatibilityImport = Boolean.valueOf(Framework.getProperty((String)"ottc.import.archive.compatibility", (String)"true"));
            if (dtm == null) {
                try {
                    Path xDocPath = xdoc.getPath();
                    Path parentPath = xDocPath.removeLastSegments(1);
                    String name = xDocPath.lastSegment();
                    DocumentModelImpl docModel = new DocumentModelImpl(parentPath.toString(), name, xdoc.getType());
                    super.loadSchemas(xdoc, (DocumentModel)docModel, xdoc.getDocument());
                }
                catch (ClientException ce) {
                    if (!BooleanUtils.isNotTrue((Boolean)compatibilityImport)) break block4;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ce.getMessage(), (Throwable)ce);
                    }
                    throw new IOException(ce.getMessage(), ce);
                }
            }
        }
        return dtm;
    }
}

