/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.userworkspace;

import java.security.Principal;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;

public class ToutaticeUserWorkspaceServiceImpl
extends DefaultUserWorkspaceServiceImpl {
    private static final long serialVersionUID = 4769849621676186385L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PathRef resolveUserWorkspace(CoreSession session, PathRef rootref, String username, String workspacename, int maxsize) {
        PathRef uwref = new PathRef(rootref, workspacename);
        try (CoreSession userSession = null;){
            CoreSession usedSession;
            NuxeoPrincipal principalCaller = (NuxeoPrincipal)session.getPrincipal();
            if (principalCaller instanceof SystemPrincipal) {
                userSession = CoreInstance.openCoreSession(null, (String)username);
            }
            CoreSession coreSession = usedSession = userSession != null ? userSession : session;
            if (!new UnrestrictedPermissionChecker(usedSession, uwref).hasPermission()) {
                int digestLength = workspacename.length() / 3;
                String substring = workspacename.substring(0, workspacename.length() - digestLength);
                PathRef pathRef = new PathRef(rootref, substring.concat(this.digest(username, digestLength)));
                return pathRef;
            }
        }
        return uwref;
    }

    protected class UnrestrictedPermissionChecker
    extends UnrestrictedSessionRunner {
        final Principal principal;
        final PathRef ref;
        boolean hasPermission;

        protected UnrestrictedPermissionChecker(CoreSession session, PathRef ref) {
            super(session);
            this.ref = ref;
            this.principal = session.getPrincipal();
        }

        public void run() {
            this.hasPermission = !this.session.exists((DocumentRef)this.ref) || this.session.hasPermission(this.principal, (DocumentRef)this.ref, "Everything");
        }

        boolean hasPermission() {
            this.runUnrestricted();
            return this.hasPermission;
        }
    }
}

