/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLDocumentVersion
extends SQLDocumentLive {
    private final Node versionableNode;

    protected SQLDocumentVersion(Node node, ComplexType type, SQLSession session, boolean readonly) throws DocumentException {
        super(node, type, session, readonly);
        Serializable versionSeriesId = this.getPropertyValue("ecm:versionableId");
        if (versionSeriesId == null) {
            throw new NoSuchDocumentException("Version was removed: " + node.getId());
        }
        this.versionableNode = session.getNodeById(versionSeriesId);
    }

    @Override
    public boolean isVersion() {
        return true;
    }

    @Override
    public boolean isCheckedOut() throws DocumentException {
        return false;
    }

    @Override
    public boolean isVersionSeriesCheckedOut() throws DocumentException {
        if (this.versionableNode == null) {
            return false;
        }
        try {
            return !Boolean.TRUE.equals(this.versionableNode.getSimpleProperty("ecm:isCheckedIn").getValue());
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    @Override
    public boolean isMajorVersion() throws DocumentException {
        return Long.valueOf(0L).equals(this.getPropertyValue("ecm:minorVersion"));
    }

    @Override
    public boolean isLatestVersion() throws DocumentException {
        return Boolean.TRUE.equals(this.getPropertyValue("ecm:isLatestVersion"));
    }

    @Override
    public boolean isLatestMajorVersion() throws DocumentException {
        return Boolean.TRUE.equals(this.getPropertyValue("ecm:isLatestMajorVersion"));
    }

    @Override
    public Document getWorkingCopy() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getDocumentByUUID(this.versionableNode.getId().toString());
    }

    @Override
    public Document getBaseVersion() throws DocumentException {
        return null;
    }

    @Override
    public String getVersionSeriesId() throws DocumentException {
        Serializable versionSeriesId = this.getPropertyValue("ecm:versionableId");
        return this.session.idToString(versionSeriesId);
    }

    @Override
    public Document getSourceDocument() throws DocumentException {
        return this.getWorkingCopy();
    }

    @Override
    public String getPath() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getPath(this.versionableNode);
    }

    @Override
    public Document getParent() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getParent(this.versionableNode);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public void orderBefore(String src, String dest) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document addChild(String name, String typeName) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getChild(String name) throws DocumentException {
        throw new NoSuchDocumentException(name);
    }

    @Override
    public Iterator<Document> getChildren() throws DocumentException {
        return EmptyDocumentIterator.INSTANCE;
    }

    @Override
    public List<String> getChildrenIds() throws DocumentException {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChild(String name) throws DocumentException {
        return false;
    }

    @Override
    public boolean hasChildren() throws DocumentException {
        return false;
    }

    @Override
    public Document checkIn(String label, String description) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void checkOut() {
        throw new VersionNotModifiableException();
    }

    @Override
    public void restore(Document version) {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getVersion(String label) {
        return null;
    }

    @Override
    public void setPropertyValue(String name, Serializable value) throws DocumentException {
        if (this.isReadOnlyProperty(name)) {
            throw new VersionNotModifiableException(String.format("Cannot set property on a version: %s = %s", name, value));
        }
        super.setPropertyValue(name, value);
    }

    protected boolean isReadOnlyProperty(String name) {
        return this.isReadOnly() && !SQLSession.isVersionWritableProperty(name);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.equals((SQLDocumentVersion)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentVersion other) {
        return this.getNode().equals((Object)other.getNode());
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    public static class VersionNotModifiableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VersionNotModifiableException() {
        }

        public VersionNotModifiableException(String message) {
            super(message);
        }
    }
}

