/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.CollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;

public class ScalarCollectionIO
implements CollectionIO {
    protected final boolean insertAll;

    public ScalarCollectionIO(boolean insertAll) {
        this.insertAll = insertAll;
    }

    @Override
    public Serializable getCurrentFromResultSet(ResultSet rs, List<Column> columns, Model model, Serializable[] returnId, int[] returnPos) throws SQLException {
        int pos;
        Object id = null;
        Serializable value = null;
        int i = 0;
        for (Column column : columns) {
            String key = column.getKey();
            Serializable v = column.getFromResultSet(rs, ++i);
            if (key.equals("id")) {
                id = v;
                continue;
            }
            if (key.equals("pos")) continue;
            if (key.equals("item")) {
                value = v;
                continue;
            }
            throw new RuntimeException(key);
        }
        Serializable prevId = returnId[0];
        returnId[0] = id;
        returnPos[0] = pos = id != null && !id.equals(prevId) ? 0 : returnPos[0] + 1;
        return value;
    }

    @Override
    public void executeInserts(PreparedStatement ps, List<RowMapper.RowUpdate> rowus, List<Column> columns, boolean supportsBatchUpdates, String sql, JDBCConnection connection) throws SQLException {
        ArrayList<Serializable> debugValues = connection.logger.isLogEnabled() ? new ArrayList<Serializable>() : null;
        String loggedSql = supportsBatchUpdates && rowus.size() > 1 ? sql + " -- BATCHED" : sql;
        int batch = 0;
        for (RowMapper.RowUpdate rowu : rowus) {
            ++batch;
            int start = rowu.pos == -1 || this.insertAll ? 0 : rowu.pos;
            Serializable id = rowu.row.id;
            Serializable[] array = rowu.row.values;
            for (int i = start; i < array.length; ++i) {
                int n = 0;
                for (Column column : columns) {
                    Serializable v;
                    ++n;
                    String key = column.getKey();
                    if (key.equals("id")) {
                        v = id;
                    } else if (key.equals("pos")) {
                        v = Long.valueOf(i);
                    } else if (key.equals("item")) {
                        v = array[i];
                    } else {
                        throw new RuntimeException(key);
                    }
                    column.setToPreparedStatement(ps, n, v);
                    if (debugValues == null) continue;
                    debugValues.add(v);
                }
                if (debugValues != null) {
                    connection.logger.logSQL(loggedSql, debugValues);
                    debugValues.clear();
                }
                if (supportsBatchUpdates) {
                    ps.addBatch();
                    if (batch % 100 != 0) continue;
                    ps.executeBatch();
                    connection.countExecute();
                    continue;
                }
                ps.execute();
                connection.countExecute();
            }
        }
        if (supportsBatchUpdates) {
            ps.executeBatch();
            connection.countExecute();
        }
    }
}

