/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.agenda;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class WidgetsAgendaAdapterListener
implements EventListener {
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String TIME_FORMAT = "HH:mm";

    public void handleEvent(Event event) throws ClientException {
        String eventName;
        if (event.getContext() instanceof DocumentEventContext && ("documentCreated".equals(eventName = event.getName()) || "beforeDocumentModification".equals(eventName))) {
            EventContext ctx = event.getContext();
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel document = docCtx.getSourceDocument();
            CoreSession session = ctx.getCoreSession();
            if (document != null && !document.isImmutable() && document.hasSchema("vevent") && document.hasSchema("toutatice_event")) {
                DateNTimeSilentFiller runner = new DateNTimeSilentFiller(session, document, eventName);
                runner.silentRun(false);
            }
        }
    }

    private class DateNTimeSilentFiller
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;
        private String eventName;

        public DateNTimeSilentFiller(CoreSession session, DocumentModel document, String eventName) {
            super(session);
            this.document = document;
            this.eventName = eventName;
        }

        public void run() throws ClientException {
            boolean isChangeableDocument = "documentCreated".equals(this.eventName);
            WidgetsAdapterService waService = (WidgetsAdapterService)Framework.getService(WidgetsAdapterService.class);
            if (waService.isInPortalViewContext()) {
                this.fromTTCToNxDate();
            } else {
                this.fromNxToTTCDate();
            }
            if (isChangeableDocument) {
                this.session.saveDocument(this.document);
            }
        }

        private void fromTTCToNxDate() {
            GregorianCalendar ttcDateTimeEnd;
            GregorianCalendar ttcDateTimeStart;
            Boolean allDay = (Boolean)this.document.getPropertyValue("ttcevt:allDay");
            if (allDay != null) {
                this.document.setPropertyValue("vevent:allDay", (Serializable)allDay);
            }
            if (null != (ttcDateTimeStart = (GregorianCalendar)this.document.getPropertyValue("ttcevt:dateTimeBegin"))) {
                this.document.setPropertyValue("vevent:dtstart", (Serializable)ttcDateTimeStart.getTime());
            }
            if (null != (ttcDateTimeEnd = (GregorianCalendar)this.document.getPropertyValue("ttcevt:dateTimeEnd"))) {
                this.document.setPropertyValue("vevent:dtend", (Serializable)ttcDateTimeEnd.getTime());
            }
        }

        private void fromNxToTTCDate() {
            GregorianCalendar nxDateTimeEnd;
            GregorianCalendar nxDateTimeStart;
            SimpleDateFormat formatDate = new SimpleDateFormat(WidgetsAgendaAdapterListener.DATE_FORMAT);
            SimpleDateFormat formatTime = new SimpleDateFormat(WidgetsAgendaAdapterListener.TIME_FORMAT);
            Boolean allDay = (Boolean)this.document.getPropertyValue("vevent:allDay");
            if (allDay != null) {
                this.document.setPropertyValue("ttcevt:allDay", (Serializable)allDay);
            }
            if (null != (nxDateTimeStart = (GregorianCalendar)this.document.getPropertyValue("vevent:dtstart"))) {
                Date ttcDateTimeBegin = nxDateTimeStart.getTime();
                this.document.setPropertyValue("ttcevt:dateTimeBegin", (Serializable)ttcDateTimeBegin);
                String dateBegin = formatDate.format(ttcDateTimeBegin);
                this.document.setPropertyValue("ttcevt:dateBegin", (Serializable)((Object)dateBegin));
                String timeBegin = formatTime.format(ttcDateTimeBegin);
                if (StringUtils.isNotBlank((String)timeBegin)) {
                    this.document.setPropertyValue("ttcevt:timeBegin", (Serializable)((Object)timeBegin));
                }
            }
            if (null != (nxDateTimeEnd = (GregorianCalendar)this.document.getPropertyValue("vevent:dtend"))) {
                Date ttcDateTimeEnd = nxDateTimeEnd.getTime();
                this.document.setPropertyValue("ttcevt:dateTimeEnd", (Serializable)ttcDateTimeEnd);
                String dateEnd = formatDate.format(ttcDateTimeEnd);
                this.document.setPropertyValue("ttcevt:dateEnd", (Serializable)((Object)dateEnd));
                String timeEnd = formatTime.format(ttcDateTimeEnd);
                if (StringUtils.isNotBlank((String)timeEnd)) {
                    this.document.setPropertyValue("ttcevt:timeEnd", (Serializable)((Object)timeEnd));
                }
            }
        }
    }
}

