/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.notifications;

import fr.toutatice.ecm.platform.collab.tools.notifications.DocumentNotificationInfosProvider;
import fr.toutatice.ecm.platform.collab.tools.notifications.exception.DeleteUserSubscriptionException;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.platform.ec.notification.UserSubscription;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.runtime.api.Framework;

public class DocumentNotificationInfosProviderImpl
implements DocumentNotificationInfosProvider {
    private static final Log log = LogFactory.getLog(DocumentNotificationInfosProviderImpl.class);
    private static final String SUBSCRIPTION_STATUS = "subscription_status";

    @Override
    public void subscribe(CoreSession coreSession, DocumentModel currentDocument) {
        if (this.getStatus(coreSession, currentDocument) != SubscriptionStatus.can_subscribe) {
            throw new ClientException("User can not subscribe to this document");
        }
        NotificationManager notificationManager = (NotificationManager)Framework.getService(NotificationManager.class);
        NuxeoPrincipal principal = (NuxeoPrincipal)coreSession.getPrincipal();
        notificationManager.addSubscriptions("user:" + principal.getName(), currentDocument, Boolean.valueOf(false), principal);
    }

    @Override
    public void unsubscribe(CoreSession coreSession, DocumentModel currentDocument) throws ClientException, ClassNotFoundException {
        if (this.getStatus(coreSession, currentDocument) != SubscriptionStatus.can_unsubscribe) {
            throw new ClientException("User can not unsubscribe to this document");
        }
        NotificationManager notificationManager = (NotificationManager)Framework.getService(NotificationManager.class);
        NuxeoPrincipal principal = (NuxeoPrincipal)coreSession.getPrincipal();
        List listNotifs = notificationManager.getSubscriptionsForUserOnDocument("user:" + coreSession.getPrincipal().getName(), currentDocument.getId());
        notificationManager.removeSubscriptions("user:" + principal.getName(), listNotifs, currentDocument.getId());
    }

    @Override
    public void workspaceUnsubscribe(CoreSession session, DocumentModel workspace, String user) throws ClientException, ClassNotFoundException {
        NotificationManager notificationManager = (NotificationManager)Framework.getService(NotificationManager.class);
        DocumentModelList usersubscriptions = this.getSubscriptionsFor(session, user);
        for (DocumentModel subscr : usersubscriptions) {
            if (!StringUtils.startsWith((String)subscr.getPathAsString(), (String)workspace.getPathAsString())) continue;
            List listNotifs = notificationManager.getSubscriptionsForUserOnDocument("user:" + user, subscr.getId());
            notificationManager.removeSubscriptions("user:" + user, listNotifs, subscr.getId());
        }
    }

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put(SUBSCRIPTION_STATUS, this.getStatus(coreSession, currentDocument).toString());
        return infos;
    }

    public SubscriptionStatus getStatus(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        SubscriptionStatus status = SubscriptionStatus.no_subscriptions;
        if (!(ToutaticeDocumentHelper.isInPublishSpace((CoreSession)coreSession, (DocumentModel)currentDocument) || currentDocument.getType().equals("Domain") || currentDocument.getType().equals("WorkspaceRoot"))) {
            List subscriptionsForUserOnDocument;
            NotificationManager notificationManager = (NotificationManager)Framework.getService(NotificationManager.class);
            try {
                subscriptionsForUserOnDocument = notificationManager.getSubscriptionsForUserOnDocument("user:" + coreSession.getPrincipal().getName(), currentDocument.getId());
            }
            catch (ClassNotFoundException e) {
                throw new ClientException((Throwable)e);
            }
            if (subscriptionsForUserOnDocument.size() > 0) {
                status = SubscriptionStatus.can_unsubscribe;
            } else {
                PlacefulService service;
                NuxeoPrincipal currentUser = (NuxeoPrincipal)coreSession.getPrincipal();
                try {
                    service = NotificationServiceHelper.getPlacefulService();
                }
                catch (Exception e) {
                    throw new ClientException((Throwable)e);
                }
                String className = (String)service.getAnnotationRegistry().get("UserSubscription");
                String shortClassName = className.substring(className.lastIndexOf(46) + 1);
                PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
                ArrayList<Annotation> tempSubscriptions = new ArrayList<Annotation>();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("userId", "user:" + currentUser.getName());
                tempSubscriptions.addAll(serviceBean.getAnnotationListByParamMap(paramMap, shortClassName));
                status = this.isSubsInheritDocument(coreSession, tempSubscriptions, currentDocument) ? SubscriptionStatus.has_inherited_subscriptions : SubscriptionStatus.can_subscribe;
            }
        }
        return status;
    }

    private boolean isSubsInheritDocument(CoreSession coreSession, List<Annotation> allSubscriptions, DocumentModel currentDoc) throws ClientException {
        for (Annotation obj : allSubscriptions) {
            UserSubscription us = (UserSubscription)obj;
            try {
                DocumentModel doc = ToutaticeDocumentHelper.getUnrestrictedDocument((CoreSession)coreSession, (String)us.getDocId());
                String path = doc.getPathAsString();
                boolean contains = StringUtils.contains((String)currentDoc.getPathAsString(), (String)path);
                if (!contains) continue;
                return true;
            }
            catch (ClientException de) {
                if (!(de.getCause() instanceof NoSuchDocumentException)) continue;
                this.removeUserSubscription(coreSession, us);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("NoSuchDocumentException: subscription " + us.getNotification() + " on document " + us.getDocId() + "for user " + us.getUserId() + " removed"));
            }
        }
        return false;
    }

    @Override
    public DocumentModelList getUserSubscriptions(CoreSession coreSession) {
        return this.getSubscriptionsFor(coreSession, coreSession.getPrincipal().getName());
    }

    private DocumentModelList getSubscriptionsFor(CoreSession coreSession, String user) {
        DocumentModelListImpl documentsSubscribed = new DocumentModelListImpl();
        PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userId", "user:" + user);
        String className = (String)serviceBean.getAnnotationRegistry().get("UserSubscription");
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        ArrayList userSubscriptions = new ArrayList();
        userSubscriptions.addAll(serviceBean.getAnnotationListByParamMap(paramMap, shortClassName));
        for (Annotation subscription : userSubscriptions) {
            UserSubscription us = (UserSubscription)subscription;
            try {
                DocumentModel subscribedDoc = coreSession.getDocument((DocumentRef)new IdRef(us.getDocId()));
                documentsSubscribed.add((Object)subscribedDoc);
            }
            catch (ClientException ce) {
                this.repareUserSubscription(coreSession, us, ce);
            }
        }
        return documentsSubscribed;
    }

    protected void repareUserSubscription(CoreSession session, UserSubscription us, ClientException ce) throws DeleteUserSubscriptionException {
        if (ce.getCause() instanceof NoSuchDocumentException) {
            this.removeUserSubscription(session, us);
            if (log.isDebugEnabled()) {
                log.debug((Object)("NoSuchDocumentException: subscription " + us.getNotification() + " on document " + us.getDocId() + "for user " + us.getUserId() + " removed"));
            }
        } else if (ce instanceof DocumentSecurityException) {
            this.removeUserSubscription(session, us);
            if (log.isDebugEnabled()) {
                log.debug((Object)("DocumentSecurityException: subscription " + us.getNotification() + " on document " + us.getDocId() + "for user " + us.getUserId() + " removed"));
            }
        } else {
            throw ce;
        }
    }

    protected void removeUserSubscription(CoreSession session, UserSubscription us) throws DeleteUserSubscriptionException {
        String currentUserId = "user:" + session.getPrincipal().getName();
        if (!StringUtils.equals((String)us.getUserId(), (String)currentUserId)) {
            throw new DeleteUserSubscriptionException("Trying deleting subscription for user " + us.getUserId() + "instead of user " + currentUserId);
        }
        NotificationServiceHelper.getNotificationService().removeSubscription(us.getUserId(), us.getNotification(), us.getDocId());
    }

    public static enum SubscriptionStatus {
        can_subscribe,
        can_unsubscribe,
        has_inherited_subscriptions,
        no_subscriptions;

    }
}

