/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.Xml2TextHandler;

public class XML2TextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(XML2TextConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        InputStream stream = null;
        try {
            stream = blobHolder.getBlob().getStream();
            Xml2TextHandler xml2text = new Xml2TextHandler();
            String text = xml2text.parse(stream);
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)new StringBlob(text, "text/plain"));
            return simpleCachableBlobHolder;
        }
        catch (Exception e) {
            throw new ConversionException("Error during XML2Text conversion", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing Blob stream", (Throwable)e);
                }
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

