/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class DocumentSuggestion
extends Suggestion {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "nxdoc";
    private static final String VIEW_ID = "view_documents";
    protected final DocumentLocation documentLocation;

    public DocumentSuggestion(String id, DocumentLocation documentLocation, String label, String iconURL) {
        super(id, "document", label, iconURL);
        this.documentLocation = documentLocation;
    }

    public static Suggestion fromDocumentModel(DocumentModel doc) throws ClientException {
        TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
        String description = (String)doc.getProperty("dc:description").getValue(String.class);
        String icon = null;
        if (doc.hasSchema("common")) {
            icon = (String)doc.getProperty("common", "icon");
        }
        if (StringUtils.isEmpty(icon)) {
            icon = typeInfo.getIcon();
        }
        return new DocumentSuggestion(doc.getId(), (DocumentLocation)new DocumentLocationImpl(doc), doc.getTitle(), icon).withDescription(description);
    }

    public DocumentLocation getDocumentLocation() {
        return this.documentLocation;
    }

    @Override
    public String getObjectUrl() {
        if (this.documentLocation != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(PREFIX);
            items.add(this.documentLocation.getServerName());
            IdRef docRef = this.documentLocation.getIdRef();
            if (docRef == null) {
                return null;
            }
            items.add(docRef.toString());
            items.add(VIEW_ID);
            String uri = StringUtils.join(items, (String)"/");
            return uri;
        }
        return null;
    }
}

