/*
 * Decompiled with CFR 0.152.
 */
package com.cforcoding.jmd;

import com.cforcoding.text.ReplaceCallback;
import com.cforcoding.text.TextUtils;
import com.cforcoding.text.TokenizeCallback;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkDown {
    public static final String EMPTY_ELEMENT_SUFFIX = " />";
    public static final int TAB_WIDTH = 4;
    public static final int NESTED_BRACKET_DEPTH = 6;
    public static final boolean LINK_EMAILS = true;
    public boolean ENCODE_EMAIL = true;
    public static final boolean STRICT_BOLD_ITALIC = false;
    public static final boolean AUTO_NEWLINES = false;
    private static final boolean AUTO_HYPERLINK = false;
    private static final boolean ENCODE_PROBLEM_URL_CHARACTERS = false;
    private static final String MARKER_UL_PATTERN = "[*+-]";
    private static final Pattern MARKER_UL = Pattern.compile("[*+-]");
    private static final String MARKER_OL_PATTERN = "\\d+[.]";
    private static final String NESTED_BRACKETS_PATTERN = String.valueOf(TextUtils.repeat("(?>[^\\[\\]]+|\\[", 6)) + TextUtils.repeat("\\])*", 6);
    private static final String NESTED_PARENS_PATTERN = String.valueOf(TextUtils.repeat("(?>[^()\\s]+|\\(", 6)) + TextUtils.repeat("\\))*", 6);
    private static final String MARKER_ANY_PATTERN = String.format("(?:%s|%s)", "\\d+[.]", "[*+-]");
    private static final String ESCAPE_CHARACTERS = "\\`*_{}[]()>#+-.!";
    private static final Map<String, String> ESCAPE_TABLE;
    private static final Map<String, String> BACKSLASH_ESCAPE_TABLE;
    private static final String BOLD_PATTERN;
    private static final String BOLD_REPLACE;
    private static final String ITALIC_PATTERN;
    private static final String ITALIC_REPLACE;
    private static final Pattern LINE_BREAK;
    private static final String LINE_BREAK_ELEMENT = "<br />";
    private static final String ESCAPE_PREFIX = "MDESCAPENEXT";
    private static final String ESCAPE_SUFFIX = "IWANTMYMDTOBREAK";
    private Map<String, String> urls;
    private Map<String, String> titles;
    private Map<String, String> htmlBlocks;
    private int listLevel = 0;
    private static final String LINK_PATTERN;
    private static final Pattern LINK;
    private final ReplaceCallback linkCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String linkId = match.group(1).toLowerCase();
            MarkDown.this.urls.put(linkId, MarkDown.encodeAmpsAndAngles(match.group(2)));
            if (match.group(3) != null && match.group(3).length() > 0) {
                MarkDown.this.titles.put(linkId, match.group(3).replace("\"", "&quot;"));
            }
            return "";
        }
    };
    private static final String BLOCK_TAGS_1 = "p|div|h[1-6]|blockquote|pre|table|dl|ol|ul|script|noscript|form|fieldset|iframe|math|ins|del";
    private static final String BLOCKS_NESTED_PATTERN;
    private static final Pattern BLOCKS_NESTED;
    private static final String BLOCK_TAGS_2 = "p|div|h[1-6]|blockquote|pre|table|dl|ol|ul|script|noscript|form|fieldset|iframe|math";
    private static final String BLOCKS_NESTED_LIBERAL_PATTERN;
    private static final Pattern BLOCKS_NESTED_LIBERAL;
    private static final String BLOCKS_HR_PATTERN;
    private static final Pattern BLOCKS_HR;
    private static final String BLOCK_HTML_COMMENTS_PATTERN;
    private static final Pattern BLOCK_HTML_COMMENTS;
    private final ReplaceCallback htmlBlockCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String text = match.group(1);
            String key = Integer.toString(text.hashCode());
            MarkDown.this.htmlBlocks.put(key, text);
            return "\n\n" + key + "\n\n";
        }
    };
    private static final Pattern BLOCK_1;
    private static final Pattern BLOCK_2;
    private static final Pattern BLOCK_3;
    private static final String HR = "<hr />\n";
    private static final Pattern HTML_TOKENS;
    private static final Pattern CODE;
    private static final String ANCHOR_REF_PATTERN;
    private static final Pattern ANCHOR_REF;
    private final ReplaceCallback anchorRefCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String output;
            String wholeMatch = match.group(1);
            String linkText = match.group(2);
            String linkId = match.group(3).toLowerCase();
            if (TextUtils.empty(linkId)) {
                linkId = linkText.toLowerCase();
            }
            if (MarkDown.this.urls.containsKey(linkId)) {
                String url = (String)MarkDown.this.urls.get(linkId);
                url = MarkDown.this.encodeProblemUrlChars(url);
                StringBuilder sb = new StringBuilder();
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\"");
                if (MarkDown.this.titles.containsKey(linkId)) {
                    String title = (String)MarkDown.this.titles.get(linkId);
                    title = MarkDown.this.escapeBoldItalic(title);
                    sb.append(" title=\"");
                    sb.append(title);
                    sb.append("\"");
                }
                sb.append(">");
                sb.append(linkText);
                sb.append("</a>");
                output = sb.toString();
            } else {
                output = wholeMatch;
            }
            return output;
        }
    };
    private static final String ANCHOR_INLINE_PATTERN;
    private static final Pattern ANCHOR_INLINE;
    private final ReplaceCallback anchorInlineCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String linkText = match.group(2);
            String url = match.group(3);
            String title = match.group(6);
            if ((url = MarkDown.this.escapeBoldItalic(url)).startsWith("<") && url.endsWith(">")) {
                url = url.substring(1, url.length() - 1);
            }
            url = MarkDown.this.encodeProblemUrlChars(url);
            StringBuilder output = new StringBuilder();
            output.append("<a href=\"");
            output.append(url);
            output.append("\"");
            if (!TextUtils.empty(title)) {
                title = title.replace("\"", "&quot;");
                title = MarkDown.this.escapeBoldItalic(title);
                output.append(" title=\"");
                output.append(title);
                output.append("\"");
            }
            output.append(">");
            output.append(linkText);
            output.append("</a>");
            return output.toString();
        }
    };
    private static final Pattern EMBEDDED_NEWLINES;
    private static final Pattern ANCHOR_REF_SHORTCUT;
    private final ReplaceCallback anchorRefShortcutCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String result;
            String wholeMatch = match.group(1);
            String linkText = match.group(2);
            String linkId = TextUtils.replace(EMBEDDED_NEWLINES, linkText, " ");
            if (MarkDown.this.urls.containsKey(linkId)) {
                String url = (String)MarkDown.this.urls.get(linkId);
                url = MarkDown.this.escapeBoldItalic(url);
                url = MarkDown.this.encodeProblemUrlChars(url);
                StringBuilder sb = new StringBuilder();
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\"");
                if (MarkDown.this.titles.containsKey(linkId)) {
                    String title = (String)MarkDown.this.titles.get(linkId);
                    title = MarkDown.this.escapeBoldItalic(title);
                    sb.append(" title=\"");
                    sb.append(title);
                    sb.append("\"");
                }
                sb.append(">");
                sb.append(linkText);
                sb.append("</a>");
                result = sb.toString();
            } else {
                result = wholeMatch;
            }
            return result;
        }
    };
    private static final Pattern LINK_COLON;
    private static final Pattern IMAGES_REF;
    private final ReplaceCallback imageReferenceCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String output;
            String wholeMatch = match.group(1);
            String altText = match.group(2);
            String linkId = match.group(3).toLowerCase();
            if (TextUtils.empty(linkId)) {
                linkId = altText.toLowerCase();
            }
            altText = altText.replace("\"", "&quot;");
            if (MarkDown.this.urls.containsKey(linkId)) {
                String url = (String)MarkDown.this.urls.get(linkId);
                url = MarkDown.this.encodeProblemUrlChars(url);
                StringBuilder sb = new StringBuilder();
                sb.append("<img src=\"");
                sb.append(url);
                sb.append("\" alt=\"");
                sb.append(altText);
                sb.append("\"");
                if (MarkDown.this.titles.containsKey(linkId)) {
                    String title = (String)MarkDown.this.titles.get(linkId);
                    title = MarkDown.this.escapeBoldItalic(title);
                    sb.append(" title=\"");
                    sb.append(title);
                    sb.append("\"");
                }
                sb.append(MarkDown.EMPTY_ELEMENT_SUFFIX);
                output = sb.toString();
            } else {
                output = wholeMatch;
            }
            return output;
        }
    };
    private static final Pattern ENCLOSING_LT_GT;
    private static final String IMAGES_INLINE_PATTERN;
    private static final Pattern IMAGES_INLINE;
    private final ReplaceCallback imageInlineCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String alt = match.group(2);
            String url = match.group(3);
            String title = match.group(6);
            alt = alt.replace("\"", "&quot;");
            if (title != null) {
                title = title.replace("\"", "&quot;");
            }
            url = MarkDown.this.encodeProblemUrlChars(url);
            url = TextUtils.replace(ENCLOSING_LT_GT, url, "$1");
            StringBuilder output = new StringBuilder();
            output.append("<img src=\"");
            output.append(url);
            output.append("\" alt=\"");
            output.append(alt);
            output.append("\"");
            if (!TextUtils.empty(title)) {
                title = MarkDown.this.escapeBoldItalic(title);
                output.append(" title=\"");
                output.append(title);
                output.append("\"");
            }
            output.append(MarkDown.EMPTY_ELEMENT_SUFFIX);
            return output.toString();
        }
    };
    private static final Pattern HEADER_1;
    private final ReplaceCallback header1Callback = new ReplaceCallback(){

        public String match(MatchResult match) {
            return String.format("<h1>%s</h1>\n\n", MarkDown.this.runSpanGamut(match.group(1)));
        }
    };
    private static final Pattern HEADER_2;
    private final ReplaceCallback header2Callback = new ReplaceCallback(){

        public String match(MatchResult match) {
            return String.format("<h2>%s</h2>\n\n", MarkDown.this.runSpanGamut(match.group(1)));
        }
    };
    private static final Pattern HEADER_HASH;
    private final ReplaceCallback headerHashCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String headerSig = match.group(1);
            String headerText = match.group(2);
            return String.format("<h%d>%s</h%d>\n\n", headerSig.length(), MarkDown.this.runSpanGamut(headerText), headerSig.length());
        }
    };
    private static final String WHOLE_LIST_PATTERN;
    private static final Pattern LIST_NESTED;
    private static final Pattern LIST_TOP_LEVEL;
    private static final Pattern TWO_PLUS_NEWLINES;
    private static final Pattern TWO_PLUS_NEWLINES_Z;
    private final ReplaceCallback listCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String list = match.group(1);
            String listType = TextUtils.matches(MARKER_UL, match.group(3)) ? "ul" : "ol";
            list = TextUtils.replace(TWO_PLUS_NEWLINES, list, "\n\n\n");
            String output = MarkDown.this.processListItems(list, MARKER_ANY_PATTERN);
            output = String.format("<%s>\n%s</%s>\n", listType, output, listType);
            return output;
        }
    };
    private static final Pattern TRAILING_NEWLINES;
    private final ReplaceCallback listCallback2 = new ReplaceCallback(){

        public String match(MatchResult match) {
            String item = match.group(4);
            String leadingLine = match.group(1);
            if (!TextUtils.empty(leadingLine) || TextUtils.find(TWO_PLUS_NEWLINES, item)) {
                item = MarkDown.this.runBlockGamut(MarkDown.this.outdent(item));
            } else {
                item = MarkDown.this.doLists(MarkDown.this.outdent(item));
                item = TextUtils.replace(TRAILING_NEWLINES, item, "");
                item = MarkDown.this.runSpanGamut(item);
            }
            return String.format("<li>%s</li>\n", item);
        }
    };
    private static final String CODE_BLOCK_PATTERN;
    private static final Pattern CODE_BLOCK;
    private static final Pattern LEADING_NEWLINES;
    private static final Pattern TRAILING_NEWLINES_Z;
    private final ReplaceCallback codeBlockCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String codeBlock = match.group(1);
            codeBlock = MarkDown.this.encodeCode(MarkDown.this.outdent(codeBlock));
            codeBlock = MarkDown.this.detab(codeBlock);
            codeBlock = TextUtils.replace(LEADING_NEWLINES, codeBlock, "");
            codeBlock = TextUtils.replace(TRAILING_NEWLINES_Z, codeBlock, "");
            return String.format("\n\n<pre><code>%s\n</code></pre>\n\n", codeBlock);
        }
    };
    private static final Pattern CODE_SPAN;
    private static final Pattern LEADING_WHITESPACE;
    private static final Pattern TRAILING_WHITESPACE;
    private final ReplaceCallback codeSpanCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String s = match.group(2);
            s = TextUtils.replace(LEADING_WHITESPACE, s, "");
            s = TextUtils.replace(TRAILING_WHITESPACE, s, "");
            s = MarkDown.this.encodeCode(s);
            return String.format("<code>%s</code>", s);
        }
    };
    private static final Pattern STRONG;
    private static final Pattern ITALICS;
    private static final Pattern BLOCK_QUOTE;
    private static final Pattern LEADING_QUOTE;
    private static final Pattern BLANK_LINE;
    private static final Pattern SPACE_PRE;
    private static final Pattern START_MULTI;
    private final ReplaceCallback blockQuoteCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String bq = match.group(1);
            bq = TextUtils.replace(LEADING_QUOTE, bq, "");
            bq = TextUtils.replace(BLANK_LINE, bq, "");
            bq = MarkDown.this.runBlockGamut(bq);
            bq = TextUtils.replace(START_MULTI, bq, "  ");
            bq = TextUtils.replace(SPACE_PRE, bq, MarkDown.this.blockQuoteCallback2);
            return String.format("<blockquote>\n%s\n</blockquote>\n\n", bq);
        }
    };
    private static final Pattern PRE_SPACE;
    private final ReplaceCallback blockQuoteCallback2 = new ReplaceCallback(){

        public String match(MatchResult match) {
            String pre = match.group(1);
            return TextUtils.replace(PRE_SPACE, pre, "");
        }
    };
    private static final Pattern NEWLINES_MULTI;
    private static final Pattern LEADING_TABS;
    private static final Pattern AUTO_LINK_BARE;
    private static final Pattern LINK_ESCAPE;
    private final ReplaceCallback linkEscapeCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            return MarkDown.this.encodeProblemUrlChars(match.group());
        }
    };
    private static final Pattern HYPERLINK;
    private final ReplaceCallback hyperlinkCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            return String.format("<a href=\"%s\">%<s</a>", match.group(1));
        }
    };
    private static final Pattern LINK_EMAIL;
    private final ReplaceCallback linkEmailCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            String email = MarkDown.this.unescapeSpecialChars(match.group(1));
            email = "mailto:" + email;
            email = TextUtils.replace(EMAIL_COLON, email, MarkDown.this.encodeEmailCallback);
            email = String.format("<a href=\"%s\">%<s</a>", email);
            email = TextUtils.replace(EMAIL_MAILTO, email, "\">");
            return email;
        }
    };
    private static final Pattern EMAIL_MAILTO;
    private final Random random = new Random();
    private static final Pattern EMAIL_COLON;
    private final ReplaceCallback encodeEmailCallback = new ReplaceCallback(){

        public String match(MatchResult match) {
            char c = match.group(1).charAt(0);
            if (MarkDown.this.ENCODE_EMAIL) {
                int r = MarkDown.this.random.nextInt(101);
                if (r > 90 && c != '@') {
                    return Character.toString(c);
                }
                if (r < 45) {
                    return String.format("&#x%d;", c);
                }
                return String.format("&#x%d;", c);
            }
            return Character.toString(c);
        }
    };
    private static final Pattern AMPS;
    private static final Pattern ANGLES;
    private static final String OUTDENT_PATTERN;
    private static final Pattern OUTDENT;
    private static final Pattern DETAB;
    private static final ReplaceCallback DETAB_CALLBACK;

    static {
        HashMap<String, String> escape = new HashMap<String, String>();
        HashMap<String, String> backslashEscape = new HashMap<String, String>();
        int i = 0;
        while (i < ESCAPE_CHARACTERS.length()) {
            char c = ESCAPE_CHARACTERS.charAt(i);
            String ch = Character.toString(c);
            String code = ESCAPE_PREFIX + Integer.toString(ch.hashCode()) + ESCAPE_SUFFIX;
            escape.put(ch, code);
            backslashEscape.put("\\" + ch, code);
            ++i;
        }
        ESCAPE_TABLE = Collections.unmodifiableMap(escape);
        BACKSLASH_ESCAPE_TABLE = Collections.unmodifiableMap(backslashEscape);
        BOLD_PATTERN = "(\\*\\*|__)(?=\\S)(.+?[*_]*)(?<=\\S)\\1";
        BOLD_REPLACE = "<strong>$2</strong>";
        ITALIC_PATTERN = "(\\*|_)(?=\\S)(.+?)(?<=\\S)\\1";
        ITALIC_REPLACE = "<em>$2</em>";
        LINE_BREAK = Pattern.compile(" {2,}\n");
        LINK_PATTERN = String.format("^[ ]{0,%d}\\[(.+)\\]:[ \\t]*\n?[ \\t]*<?(\\S+?)>?[ \\t]*\n?[ \\t]*(?:(?<=\\s)[\\x22(](.+?)[\\x22)][ \\t]*)?(?:\\n+|\\Z)", 3);
        LINK = Pattern.compile(LINK_PATTERN, 8);
        BLOCKS_NESTED_PATTERN = String.format("(^<(%s)\\b(?>.*\\n)*?</\\2>[ \\t]*(?=\\n+|\\Z))", BLOCK_TAGS_1);
        BLOCKS_NESTED = Pattern.compile(BLOCKS_NESTED_PATTERN, 8);
        BLOCKS_NESTED_LIBERAL_PATTERN = String.format("(^<(%s)\\b(?>.*\\n)*?.*</\\2>[ \\t]*(?=\\n+|\\Z))", BLOCK_TAGS_2);
        BLOCKS_NESTED_LIBERAL = Pattern.compile(BLOCKS_NESTED_LIBERAL_PATTERN, 8);
        BLOCKS_HR_PATTERN = String.format("(?:(?<=\\n\\n)|\\A\\n?)([ ]{0,%d}<(hr)\\b([^<>])*?/?>[ \\t]*(?=\\n{2,}|\\Z))", 3);
        BLOCKS_HR = Pattern.compile(BLOCKS_HR_PATTERN);
        BLOCK_HTML_COMMENTS_PATTERN = String.format("(?:(?<=\\n\\n)|\\A\\n?)([ ]{0,%d}(?s:<!(--.*?--\\s*)+>)[ \\t]*(?=\\n{2,}|\\Z))", 3);
        BLOCK_HTML_COMMENTS = Pattern.compile(BLOCK_HTML_COMMENTS_PATTERN);
        BLOCK_1 = Pattern.compile("^[ ]{0,2}([ ]?\\*[ ]?){3,}[ \\t]*$", 8);
        BLOCK_2 = Pattern.compile("^[ ]{0,2}([ ]?-[ ]?){3,}[ \\t]*$", 8);
        BLOCK_3 = Pattern.compile("^[ ]{0,2}([ ]?_[ ]?){3,}[ \\t]*$", 8);
        HTML_TOKENS = Pattern.compile("(?s:<!(?:--.*?--\\s*)+>)|(?s:<\\?.*?\\?>)|" + TextUtils.repeat("(?:<[a-z\\/!$](?:[^<>]|", 6) + TextUtils.repeat(")*>)", 6), 10);
        CODE = Pattern.compile("(?<=.)</?code>(?=.)");
        ANCHOR_REF_PATTERN = String.format("(\\[(%s)\\][ ]?(?:\\n[ ]*)?\\[(.*?)\\])", NESTED_BRACKETS_PATTERN);
        ANCHOR_REF = Pattern.compile(ANCHOR_REF_PATTERN, 32);
        ANCHOR_INLINE_PATTERN = String.format("(\\[(%s)\\]\\([ \\t]*(%s)[ \\t]*((['\\x22])(.*?)\\5[ \\t]*)?\\))", NESTED_BRACKETS_PATTERN, NESTED_PARENS_PATTERN);
        ANCHOR_INLINE = Pattern.compile(ANCHOR_INLINE_PATTERN, 32);
        EMBEDDED_NEWLINES = Pattern.compile("[ ]*\\n[ ]*");
        ANCHOR_REF_SHORTCUT = Pattern.compile("(\\[([^\\[\\]]+)\\])", 32);
        LINK_COLON = Pattern.compile(":(?!\\d{2,})");
        IMAGES_REF = Pattern.compile("(!\\[(.*?)\\][ ]?(?:\\n[ ]*)?\\[(.*?)\\])", 32);
        ENCLOSING_LT_GT = Pattern.compile("^<(.*)>$");
        IMAGES_INLINE_PATTERN = String.format("(!\\[(.*?)\\]\\s?\\([ \\t]*(%s)[ \\t]*((['\\x22])(.*?)\\5[ \\t]*)?\\))", NESTED_PARENS_PATTERN);
        IMAGES_INLINE = Pattern.compile(IMAGES_INLINE_PATTERN, 32);
        HEADER_1 = Pattern.compile("^(.+?)[ \t]*\n=+[ \t]*\n+", 8);
        HEADER_2 = Pattern.compile("^(.+?)[ \t]*\n-+[ \t]*\n+", 8);
        HEADER_HASH = Pattern.compile("^(#{1,6})[ \\t]*(.+?)[ \\t]*#*\\n+", 8);
        WHOLE_LIST_PATTERN = String.format("(([ ]{0,%d}(%s)[ \\t]+)(?s:.+?)(\\z|\\n{2,}(?=\\S)(?![ \\t]*%<s[ \\t]+)))", 3, MARKER_ANY_PATTERN);
        LIST_NESTED = Pattern.compile("^" + WHOLE_LIST_PATTERN, 8);
        LIST_TOP_LEVEL = Pattern.compile("(?:(?<=\\n\\n)|\\A\\n?)" + WHOLE_LIST_PATTERN, 8);
        TWO_PLUS_NEWLINES = Pattern.compile("\\n{2,}");
        TWO_PLUS_NEWLINES_Z = Pattern.compile("\\n{2,}\\z", 8);
        TRAILING_NEWLINES = Pattern.compile("\\n+$", 8);
        CODE_BLOCK_PATTERN = String.format("(?:\\n\\n|\\A)((?:(?:[ ]{%d}|\\t).*\\n+)+)((?=^[ ]{0,%<d}\\S)|\\Z)", 4);
        CODE_BLOCK = Pattern.compile(CODE_BLOCK_PATTERN, 8);
        LEADING_NEWLINES = Pattern.compile("^\\n+");
        TRAILING_NEWLINES_Z = Pattern.compile("\\n+\\z");
        CODE_SPAN = Pattern.compile("(?<!\\\\)(`+)(.+?)(?<!`)\\1(?!`)", 32);
        LEADING_WHITESPACE = Pattern.compile("^[ \\t]*");
        TRAILING_WHITESPACE = Pattern.compile("[ \\t]*$");
        STRONG = Pattern.compile(BOLD_PATTERN, 32);
        ITALICS = Pattern.compile(ITALIC_PATTERN, 32);
        BLOCK_QUOTE = Pattern.compile("((^[ \\t]*>[ \\t]?.+\\n(.+\\n)*\\n*)+)", 8);
        LEADING_QUOTE = Pattern.compile("^[ \t]*>[ \t]?", 8);
        BLANK_LINE = Pattern.compile("^[ \t]+$", 8);
        SPACE_PRE = Pattern.compile("(\\s*<pre>.+?</pre>)", 32);
        START_MULTI = Pattern.compile("^", 8);
        PRE_SPACE = Pattern.compile("^  ", 8);
        NEWLINES_MULTI = Pattern.compile("\\n{2,}", 8);
        LEADING_TABS = Pattern.compile("^([ \\t]*)");
        AUTO_LINK_BARE = Pattern.compile("(^|\\s)(https?|ftp)(://[-A-Z0-9+&@#/%?=~_|\\[\\]\\(\\)!:,\\.;]*[-A-Z0-9+&@#/%=~_|\\[\\]])($|\\W)");
        LINK_ESCAPE = Pattern.compile("<(https?|ftp)://[^>]+>");
        HYPERLINK = Pattern.compile("<((https?|ftp):[^'\">\\s]+)>");
        LINK_EMAIL = Pattern.compile("<(?:mailto:)?([-.\\w]+@[-a-z0-9]+(\\.[-a-z0-9]+)*\\.[a-z]+)>", 2);
        EMAIL_MAILTO = Pattern.compile("\">.+?:");
        EMAIL_COLON = Pattern.compile("([^:])");
        AMPS = Pattern.compile("&(?!#?[xX]?([0-9a-fA-F]+|\\w+);)");
        ANGLES = Pattern.compile("<(?![A-Za-z/?\\$!])");
        OUTDENT_PATTERN = String.format("^(\\t|[ ]{1,%d})", 4);
        OUTDENT = Pattern.compile(OUTDENT_PATTERN, 8);
        DETAB = Pattern.compile("^(.*?)(\\t+)", 8);
        DETAB_CALLBACK = new ReplaceCallback(){

            public String match(MatchResult match) {
                String leading = match.group(1);
                int tabCount = match.group(2).length();
                StringBuilder buf = new StringBuilder(leading);
                int spaceCount = 4 - leading.length() % 4 + (tabCount - 1) * 4;
                while (spaceCount-- > 0) {
                    buf.append(' ');
                }
                return buf.toString();
            }
        };
    }

    public String transform(String text) {
        this.urls = new HashMap<String, String>();
        this.titles = new HashMap<String, String>();
        this.htmlBlocks = new HashMap<String, String>();
        text = text.replace("\r\n", "\n");
        text = text.replace("\r", "\n");
        text = String.valueOf(text) + "\n\n";
        text = this.detab(text);
        text = TextUtils.replace(BLANK_LINE, text, "");
        text = this.hashHtmlBlocks(text);
        text = this.stripLinkDefinitions(text);
        text = this.runBlockGamut(text);
        text = this.unescapeSpecialChars(text);
        return String.valueOf(text) + "\n";
    }

    private String stripLinkDefinitions(String text) {
        return TextUtils.replace(LINK, text, this.linkCallback);
    }

    private String hashHtmlBlocks(String text) {
        text = TextUtils.replace(BLOCKS_NESTED, text, this.htmlBlockCallback);
        text = TextUtils.replace(BLOCKS_NESTED_LIBERAL, text, this.htmlBlockCallback);
        text = TextUtils.replace(BLOCKS_HR, text, this.htmlBlockCallback);
        text = TextUtils.replace(BLOCK_HTML_COMMENTS, text, this.htmlBlockCallback);
        return text;
    }

    private String runBlockGamut(String text) {
        text = this.doHeaders(text);
        text = TextUtils.replace(BLOCK_1, text, HR);
        text = TextUtils.replace(BLOCK_2, text, HR);
        text = TextUtils.replace(BLOCK_3, text, HR);
        text = this.doLists(text);
        text = this.doCodeBlocks(text);
        text = this.doBlockQuotes(text);
        text = this.hashHtmlBlocks(text);
        text = this.formParagraphs(text);
        return text;
    }

    private String runSpanGamut(String text) {
        text = this.doCodeSpans(text);
        text = this.escapeSpecialCharsWithinTagAttributes(text);
        text = this.encodeBackslashEscapes(text);
        text = this.doImages(text);
        text = this.doAnchors(text);
        text = this.doAutoLinks(text);
        text = MarkDown.encodeAmpsAndAngles(text);
        text = this.doItalicsAndBold(text);
        text = TextUtils.replace(LINE_BREAK, text, LINE_BREAK_ELEMENT);
        return text;
    }

    private List<Token> tokenizeHtml(String text) {
        return TextUtils.tokenize(HTML_TOKENS, text, new TokenizeCallback<Token>(){

            @Override
            public Token text(String text) {
                return new Token(TokenType.TEXT, text);
            }

            @Override
            public Token match(MatchResult match) {
                return new Token(TokenType.TAG, match.group());
            }
        });
    }

    private String escape(String text, String s) {
        String rep = ESCAPE_TABLE.get(s);
        return rep == null ? text : text.replace(s, rep);
    }

    private String escapeSpecialCharsWithinTagAttributes(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        List<Token> tokens = this.tokenizeHtml(text);
        for (Token token : tokens) {
            String value = token.value;
            if (token.type == TokenType.TAG) {
                value = this.escape(value, "\\");
                value = TextUtils.replace(CODE, value, ESCAPE_TABLE.get("`"));
                value = this.escapeBoldItalic(value);
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private String escapeBoldItalic(String s) {
        s = this.escape(s, "*");
        s = this.escape(s, "_");
        return s;
    }

    private String doAnchors(String text) {
        text = TextUtils.replace(ANCHOR_REF, text, this.anchorRefCallback);
        text = TextUtils.replace(ANCHOR_INLINE, text, this.anchorInlineCallback);
        text = TextUtils.replace(ANCHOR_REF_SHORTCUT, text, this.anchorRefShortcutCallback);
        return text;
    }

    private String encodeProblemUrlChars(String url) {
        return url;
    }

    private String doImages(String text) {
        text = TextUtils.replace(IMAGES_REF, text, this.imageReferenceCallback);
        text = TextUtils.replace(IMAGES_INLINE, text, this.imageInlineCallback);
        return text;
    }

    private String doHeaders(String text) {
        text = TextUtils.replace(HEADER_1, text, this.header1Callback);
        text = TextUtils.replace(HEADER_2, text, this.header2Callback);
        text = TextUtils.replace(HEADER_HASH, text, this.headerHashCallback);
        return text;
    }

    private String doLists(String text) {
        text = this.listLevel > 0 ? TextUtils.replace(LIST_NESTED, text, this.listCallback) : TextUtils.replace(LIST_TOP_LEVEL, text, this.listCallback);
        return text;
    }

    private String processListItems(String list, String marker) {
        ++this.listLevel;
        list = TextUtils.replace(TWO_PLUS_NEWLINES_Z, list, "\n");
        String pattern = String.format("(\\n)?(^[ \\t]*)(%s)[ \\t]+((?s:.+?)(\\n{1,2}))(?=\\n*(\\z|\\2(%<s)[ \t]+))", marker);
        list = TextUtils.replace(pattern, 8, list, this.listCallback2);
        --this.listLevel;
        return list;
    }

    private String doCodeBlocks(String text) {
        return TextUtils.replace(CODE_BLOCK, text, this.codeBlockCallback);
    }

    private String doCodeSpans(String text) {
        return TextUtils.replace(CODE_SPAN, text, this.codeSpanCallback);
    }

    private String encodeCode(String code) {
        code = code.replace("&", "&amp;");
        code = code.replace("<", "&lt;");
        code = code.replace(">", "&gt;");
        code = this.escape(code, "*");
        code = this.escape(code, "_");
        code = this.escape(code, "{");
        code = this.escape(code, "}");
        code = this.escape(code, "[");
        code = this.escape(code, "]");
        code = this.escape(code, "\\");
        return code;
    }

    private String doItalicsAndBold(String text) {
        text = TextUtils.replace(STRONG, text, BOLD_REPLACE);
        text = TextUtils.replace(ITALICS, text, ITALIC_REPLACE);
        return text;
    }

    private String doBlockQuotes(String text) {
        return TextUtils.replace(BLOCK_QUOTE, text, this.blockQuoteCallback);
    }

    private String formParagraphs(String text) {
        text = TextUtils.replace(LEADING_NEWLINES, text, "");
        text = TextUtils.replace(TRAILING_NEWLINES_Z, text, "");
        String[] paragraphs = NEWLINES_MULTI.split(text);
        int i = 0;
        while (i < paragraphs.length) {
            if (!this.htmlBlocks.containsKey(paragraphs[i])) {
                String block = paragraphs[i];
                block = this.runSpanGamut(block);
                block = TextUtils.replace(LEADING_TABS, block, "<p>");
                paragraphs[i] = block = String.valueOf(block) + "</p>";
            }
            ++i;
        }
        i = 0;
        while (i < paragraphs.length) {
            if (this.htmlBlocks.containsKey(paragraphs[i])) {
                paragraphs[i] = this.htmlBlocks.get(paragraphs[i]);
            }
            ++i;
        }
        return TextUtils.join("\n\n", paragraphs);
    }

    private String doAutoLinks(String text) {
        text = TextUtils.replace(LINK_ESCAPE, text, this.linkEscapeCallback);
        text = TextUtils.replace(HYPERLINK, text, this.hyperlinkCallback);
        text = TextUtils.replace(LINK_EMAIL, text, this.linkEmailCallback);
        return text;
    }

    public static String encodeAmpsAndAngles(String text) {
        text = TextUtils.replace(AMPS, text, "&amp;");
        text = TextUtils.replace(ANGLES, text, "&lt;");
        return text;
    }

    private String encodeBackslashEscapes(String value) {
        for (Map.Entry<String, String> entry : BACKSLASH_ESCAPE_TABLE.entrySet()) {
            value = value.replace(entry.getKey(), entry.getValue());
        }
        return value;
    }

    private String unescapeSpecialChars(String text) {
        for (Map.Entry<String, String> entry : ESCAPE_TABLE.entrySet()) {
            text = text.replace(entry.getValue(), entry.getKey());
        }
        return text;
    }

    private String outdent(String block) {
        return TextUtils.replace(OUTDENT, block, "");
    }

    private String detab(String text) {
        return TextUtils.replace(DETAB, text, DETAB_CALLBACK);
    }

    private static class Token {
        private final TokenType type;
        private final String value;

        private Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return (Object)((Object)this.type) + ": " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        TEXT,
        TAG;

    }
}

