/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.portal;

import com.noelios.restlet.util.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

public class PortalAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final String SECRET_KEY_NAME = "secret";
    private static final String MAX_AGE_KEY_NAME = "maxAge";
    private static final String TS_HEADER = "NX_TS";
    private static final String RANDOM_HEADER = "NX_RD";
    private static final String TOKEN_HEADER = "NX_TOKEN";
    private static final String USER_HEADER = "NX_USER";
    private static final String TOKEN_SEP = ":";
    private String secret = "secret";
    private long maxAge = 3600L;

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return false;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String ts = httpRequest.getHeader(TS_HEADER);
        String random = httpRequest.getHeader(RANDOM_HEADER);
        String token = httpRequest.getHeader(TOKEN_HEADER);
        String userName = httpRequest.getHeader(USER_HEADER);
        if (userName == null || ts == null || random == null || token == null) {
            return null;
        }
        if (this.validateToken(ts, random, token, userName).booleanValue()) {
            return new UserIdentificationInfo(userName, userName);
        }
        return null;
    }

    public void initPlugin(Map<String, String> parameters) {
        String maxAgeStr;
        if (parameters.containsKey(SECRET_KEY_NAME)) {
            this.secret = parameters.get(SECRET_KEY_NAME);
        }
        if (parameters.containsKey(MAX_AGE_KEY_NAME) && (maxAgeStr = parameters.get(MAX_AGE_KEY_NAME)) != null && !maxAgeStr.equals("")) {
            this.maxAge = Long.parseLong(maxAgeStr);
        }
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return false;
    }

    private Boolean validateToken(String ts, String random, String token, String userName) {
        byte[] hashedToken;
        String clearToken = ts + TOKEN_SEP + random + TOKEN_SEP + this.secret + TOKEN_SEP + userName;
        try {
            hashedToken = MessageDigest.getInstance("MD5").digest(clearToken.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        String base64HashedToken = Base64.encodeBytes((byte[])hashedToken);
        if (!base64HashedToken.equals(token)) {
            return false;
        }
        long portalTS = Long.parseLong(ts);
        long currentTS = new Date().getTime();
        return (currentTS - portalTS) / 1000L <= this.maxAge;
    }
}

