/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ServletHelper {
    private static final Log log = LogFactory.getLog(ServletHelper.class);
    public static final String TX_TIMEOUT_HEADER_KEY = "Nuxeo-Transaction-Timeout";

    private ServletHelper() {
    }

    public static boolean startTransaction(HttpServletRequest request) {
        String header = request.getHeader(TX_TIMEOUT_HEADER_KEY);
        int timeout = 0;
        if (header != null) {
            try {
                timeout = Integer.parseInt(header);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid request transaction timeout: " + header));
            }
        }
        return TransactionHelper.startTransaction((int)timeout);
    }

    public static String getRFC2231ContentDisposition(HttpServletRequest request, String filename) {
        String inline = request.getParameter("inline");
        if (inline == null) {
            inline = (String)request.getAttribute("inline");
        }
        boolean inlineFlag = inline != null && !"false".equals(inline);
        String userAgent = request.getHeader("User-Agent");
        return RFC2231.encodeContentDisposition((String)filename, (boolean)inlineFlag, (String)userAgent);
    }
}

