/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="corsConfig")
public class NuxeoCorsFilterDescriptor
implements Serializable,
Cloneable {
    private static final String PROPERTIES_PREFIX = "cors.";
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected Boolean enabled = true;
    @XNode(value="@allowGenericHttpRequests")
    protected Boolean allowGenericHttpRequests = true;
    @XNode(value="@allowOrigin")
    protected String allowOrigin;
    @XNode(value="@allowSubdomains")
    protected boolean allowSubdomains = false;
    @XNode(value="@supportedMethods")
    protected String supportedMethods;
    @XNode(value="@supportedHeaders")
    protected String supportedHeaders;
    @XNode(value="@exposedHeaders")
    protected String exposedHeaders;
    @XNode(value="@supportsCredentials")
    protected Boolean supportsCredentials = true;
    @XNode(value="@maxAge")
    protected int maxAge = -1;
    protected String pattern = "";

    @XNode(value="pattern")
    public void setPattern(String pattern) {
        this.pattern = Framework.expandVars((String)pattern);
    }

    public FilterConfig buildFilterConfig() {
        final Dictionary<String, String> parameters = this.buildDictionary();
        return new FilterConfig(){

            public String getFilterName() {
                return "NuxeoCorsFilterDescriptor";
            }

            public ServletContext getServletContext() {
                return null;
            }

            public String getInitParameter(String name) {
                return (String)parameters.get(name);
            }

            public Enumeration getInitParameterNames() {
                return parameters.keys();
            }
        };
    }

    public boolean isMatching(HttpServletRequest request) {
        return !StringUtils.isEmpty((String)this.pattern) && request.getRequestURI().matches(this.pattern);
    }

    public NuxeoCorsFilterDescriptor clone() throws CloneNotSupportedException {
        NuxeoCorsFilterDescriptor n = new NuxeoCorsFilterDescriptor();
        n.name = this.name;
        n.allowGenericHttpRequests = this.allowGenericHttpRequests;
        n.allowOrigin = this.allowOrigin;
        n.allowSubdomains = this.allowSubdomains;
        n.supportedMethods = this.supportedMethods;
        n.supportedHeaders = this.supportedHeaders;
        n.exposedHeaders = this.exposedHeaders;
        n.supportsCredentials = this.supportsCredentials;
        n.maxAge = this.maxAge;
        n.pattern = this.pattern;
        return n;
    }

    public void merge(NuxeoCorsFilterDescriptor o) {
        this.allowGenericHttpRequests = o.allowGenericHttpRequests;
        this.supportsCredentials = o.supportsCredentials;
        this.allowSubdomains = o.allowSubdomains;
        if (!StringUtils.isEmpty((String)o.allowOrigin)) {
            this.allowOrigin = o.allowOrigin;
        }
        if (!StringUtils.isEmpty((String)o.supportedMethods)) {
            this.supportedMethods = o.supportedMethods;
        }
        if (!StringUtils.isEmpty((String)o.supportedHeaders)) {
            this.supportedHeaders = o.supportedHeaders;
        }
        if (!StringUtils.isEmpty((String)o.exposedHeaders)) {
            this.exposedHeaders = o.exposedHeaders;
        }
        if (this.maxAge == -1) {
            this.maxAge = o.maxAge;
        }
        if (!StringUtils.isEmpty((String)o.pattern)) {
            this.pattern = o.pattern;
        }
    }

    protected Dictionary<String, String> buildDictionary() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        ((Dictionary)params).put("cors.allowGenericHttpRequests", Boolean.toString(this.allowGenericHttpRequests));
        if (!StringUtils.isEmpty((String)this.allowOrigin)) {
            ((Dictionary)params).put("cors.allowOrigin", this.allowOrigin);
        }
        ((Dictionary)params).put("cors.allowSubdomains", Boolean.toString(this.allowSubdomains));
        if (!StringUtils.isEmpty((String)this.supportedMethods)) {
            ((Dictionary)params).put("cors.supportedMethods", this.supportedMethods);
        }
        if (!StringUtils.isEmpty((String)this.supportedHeaders)) {
            ((Dictionary)params).put("cors.supportedHeaders", this.supportedHeaders);
        }
        if (!StringUtils.isEmpty((String)this.exposedHeaders)) {
            ((Dictionary)params).put("cors.exposedHeaders", this.exposedHeaders);
        }
        ((Dictionary)params).put("cors.supportsCredentials", Boolean.toString(this.supportsCredentials));
        ((Dictionary)params).put("cors.maxAge", Integer.toString(this.maxAge));
        return params;
    }
}

