/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.ArrayList;
import java.util.Arrays;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;

@XObject(value="doctype")
public class DocumentTypeDescriptor {
    @XNode(value="@name")
    public String name;
    @XNodeList(value="schema", type=SchemaDescriptor[].class, componentType=SchemaDescriptor.class)
    public SchemaDescriptor[] schemas;
    @XNode(value="@extends")
    public String superTypeName;
    @XNodeList(value="facet@name", type=String[].class, componentType=String.class)
    public String[] facets;
    @XNode(value="prefetch")
    public String prefetch;
    @XNode(value="@append")
    public boolean append = false;

    public DocumentTypeDescriptor() {
    }

    public DocumentTypeDescriptor(String superTypeName, String name, SchemaDescriptor[] schemas, String[] facets) {
        this.name = name;
        this.superTypeName = superTypeName;
        this.schemas = schemas;
        this.facets = facets;
    }

    public String toString() {
        return "DocType: " + this.name;
    }

    public DocumentTypeDescriptor clone() {
        DocumentTypeDescriptor clone = new DocumentTypeDescriptor();
        clone.name = this.name;
        clone.schemas = this.schemas;
        clone.superTypeName = this.superTypeName;
        clone.facets = this.facets;
        clone.prefetch = this.prefetch;
        clone.append = this.append;
        return clone;
    }

    public DocumentTypeDescriptor merge(DocumentTypeDescriptor other) {
        if (this.schemas == null) {
            this.schemas = other.schemas;
        } else if (other.schemas != null) {
            ArrayList<SchemaDescriptor> mergedSchemas = new ArrayList<SchemaDescriptor>(Arrays.asList(this.schemas));
            mergedSchemas.addAll(Arrays.asList(other.schemas));
            this.schemas = mergedSchemas.toArray(new SchemaDescriptor[mergedSchemas.size()]);
        }
        if (this.facets == null) {
            this.facets = other.facets;
        } else if (other.facets != null) {
            ArrayList<String> mergedFacets = new ArrayList<String>(Arrays.asList(this.facets));
            mergedFacets.addAll(Arrays.asList(other.facets));
            this.facets = mergedFacets.toArray(new String[mergedFacets.size()]);
        }
        if (this.prefetch == null) {
            this.prefetch = other.prefetch;
        } else if (other.prefetch != null) {
            this.prefetch = this.prefetch + " " + other.prefetch;
        }
        return this;
    }
}

