/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.browse;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleGroupTreeHelper;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.browse.ArtifactLabel;
import org.nuxeo.apidoc.browse.NuxeoArtifactWebObject;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.search.ArtifactSearcher;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.apidoc.tree.TreeHelper;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.platform.rendering.wiki.WikiSerializer;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="apibrowser")
public class ApiBrowser
extends DefaultObject {
    protected String distributionId;
    protected boolean embeddedMode = false;

    protected SnapshotManager getSnapshotManager() {
        return (SnapshotManager)Framework.getLocalService(SnapshotManager.class);
    }

    protected ArtifactSearcher getSearcher() {
        return (ArtifactSearcher)Framework.getLocalService(ArtifactSearcher.class);
    }

    protected void initialize(Object ... args) {
        this.distributionId = (String)args[0];
        if (args.length > 1) {
            Boolean embed = (Boolean)args[1];
            this.embeddedMode = embed == null ? false : embed;
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @javax.ws.rs.Path(value="tree")
    public Object tree(@QueryParam(value="root") String source) {
        return TreeHelper.updateTree(this.getContext(), source);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="treeView")
    public Object treeView() {
        return this.getView("tree").arg("distId", this.ctx.getProperty("distId"));
    }

    @GET
    @Produces(value={"text/html"})
    public Object doGet() {
        if (this.embeddedMode) {
            DistributionSnapshot snap = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession());
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            stats.put("bundles", snap.getBundleIds().size());
            stats.put("jComponents", snap.getJavaComponentIds().size());
            stats.put("xComponents", snap.getXmlComponentIds().size());
            stats.put("services", snap.getServiceIds().size());
            stats.put("xps", snap.getExtensionPointIds().size());
            stats.put("contribs", snap.getComponentIds().size());
            return this.getView("indexSimple").arg("distId", this.ctx.getProperty("distId")).arg("stats", stats);
        }
        return this.getView("index").arg("distId", this.ctx.getProperty("distId"));
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listBundleGroups")
    public Object getMavenGroups() {
        BundleGroupTreeHelper bgth = new BundleGroupTreeHelper(this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()));
        List tree = bgth.getBundleGroupTree();
        return this.getView("listBundleGroups").arg("tree", (Object)tree).arg("distId", this.ctx.getProperty("distId"));
    }

    public Map<String, DocumentationItem> getDescriptions(String targetType) throws Exception {
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        return ds.getAvailableDescriptions(this.getContext().getCoreSession(), targetType);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listBundles")
    public Object getBundles() {
        List bundleIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getBundleIds();
        return this.getView("listBundles").arg("bundleIds", (Object)bundleIds).arg("distId", this.ctx.getProperty("distId"));
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="filterBundles")
    public Object filterBundles() throws Exception {
        String fulltext = this.getContext().getForm().getFormProperty("fulltext");
        List artifacts = this.getSearcher().filterArtifact(this.getContext().getCoreSession(), this.distributionId, "NXBundle", fulltext);
        ArrayList<String> bundleIds = new ArrayList<String>();
        for (NuxeoArtifact item : artifacts) {
            bundleIds.add(item.getId());
        }
        return this.getView("listBundles").arg("bundleIds", bundleIds).arg("distId", this.ctx.getProperty("distId")).arg("searchFilter", (Object)fulltext);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listComponents")
    public Object getComponents() {
        List javaComponentIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getJavaComponentIds();
        ArrayList<ArtifactLabel> javaLabels = new ArrayList<ArtifactLabel>();
        for (String id : javaComponentIds) {
            javaLabels.add(ArtifactLabel.createLabelFromComponent(id));
        }
        List xmlComponentIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getXmlComponentIds();
        ArrayList<ArtifactLabel> xmlLabels = new ArrayList<ArtifactLabel>();
        for (String id : xmlComponentIds) {
            xmlLabels.add(ArtifactLabel.createLabelFromComponent(id));
        }
        Collections.sort(javaLabels);
        Collections.sort(xmlLabels);
        return this.getView("listComponents").arg("javaComponents", javaLabels).arg("xmlComponents", xmlLabels).arg("distId", this.ctx.getProperty("distId"));
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="filterComponents")
    public Object filterComponents() throws Exception {
        String fulltext = this.getContext().getForm().getFormProperty("fulltext");
        List artifacts = this.getSearcher().filterArtifact(this.getContext().getCoreSession(), this.distributionId, "NXComponent", fulltext);
        ArrayList<ArtifactLabel> xmlLabels = new ArrayList<ArtifactLabel>();
        ArrayList<ArtifactLabel> javaLabels = new ArrayList<ArtifactLabel>();
        for (NuxeoArtifact item : artifacts) {
            ComponentInfo ci = (ComponentInfo)item;
            if (ci.isXmlPureComponent()) {
                xmlLabels.add(ArtifactLabel.createLabelFromComponent(ci.getId()));
                continue;
            }
            javaLabels.add(ArtifactLabel.createLabelFromComponent(ci.getId()));
        }
        return this.getView("listComponents").arg("javaComponents", javaLabels).arg("xmlComponents", xmlLabels).arg("distId", this.ctx.getProperty("distId")).arg("searchFilter", (Object)fulltext);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listServices")
    public Object getServices() {
        List serviceIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getServiceIds();
        ArrayList<ArtifactLabel> serviceLabels = new ArrayList<ArtifactLabel>();
        for (String id : serviceIds) {
            serviceLabels.add(ArtifactLabel.createLabelFromService(id));
        }
        Collections.sort(serviceLabels);
        return this.getView("listServices").arg("services", serviceLabels).arg("distId", this.ctx.getProperty("distId"));
    }

    protected Map<String, String> getRenderedDescriptions(String type) throws Exception {
        Map<String, DocumentationItem> descs = this.getDescriptions(type);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : descs.keySet()) {
            DocumentationItem docItem = descs.get(key);
            String content = docItem.getContent();
            if ("wiki".equals(docItem.getRenderingType())) {
                StringReader reader = new StringReader(content);
                WikiSerializer engine = new WikiSerializer();
                StringWriter writer = new StringWriter();
                engine.serialize((Reader)reader, (Writer)writer);
                content = writer.getBuffer().toString();
            } else {
                content = "<div class='doc'>" + content + "</div>";
            }
            result.put(key, content);
        }
        return result;
    }

    @GET
    @Produces(value={"text/plain"})
    @javax.ws.rs.Path(value="feedServices")
    public String feedServices() throws Exception {
        List serviceIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getServiceIds();
        Map<String, String> descs = this.getRenderedDescriptions("NXService");
        ArrayList<ArtifactLabel> serviceLabels = new ArrayList<ArtifactLabel>();
        for (String id : serviceIds) {
            serviceLabels.add(ArtifactLabel.createLabelFromService(id));
        }
        Collections.sort(serviceLabels);
        JSONArray array = new JSONArray();
        for (ArtifactLabel label : serviceLabels) {
            JSONObject object = new JSONObject();
            object.put("id", (Object)label.getId());
            object.put("label", (Object)label.getLabel());
            object.put("desc", (Object)descs.get(label.id));
            object.put("url", (Object)("http://explorer.nuxeo.org/nuxeo/site/distribution/current/service2Bundle/" + label.id));
            array.put((Object)object);
        }
        return array.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @javax.ws.rs.Path(value="feedExtensionPoints")
    public String feedExtensionPoints() throws Exception {
        List epIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getExtensionPointIds();
        Map<String, String> descs = this.getRenderedDescriptions("NXExtensionPoint");
        ArrayList<ArtifactLabel> labels = new ArrayList<ArtifactLabel>();
        for (String id : epIds) {
            labels.add(ArtifactLabel.createLabelFromExtensionPoint(id));
        }
        Collections.sort(labels);
        JSONArray array = new JSONArray();
        for (ArtifactLabel label : labels) {
            JSONObject object = new JSONObject();
            object.put("id", (Object)label.getId());
            object.put("label", (Object)label.getLabel());
            object.put("desc", (Object)descs.get(label.id));
            object.put("url", (Object)("http://explorer.nuxeo.org/nuxeo/site/distribution/current/extensionPoint2Component/" + label.id));
            array.put((Object)object);
        }
        return array.toString();
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="filterServices")
    public Object filterServices() throws Exception {
        String fulltext = this.getContext().getForm().getFormProperty("fulltext");
        List artifacts = this.getSearcher().filterArtifact(this.getContext().getCoreSession(), this.distributionId, "NXService", fulltext);
        ArrayList<String> serviceIds = new ArrayList<String>();
        for (NuxeoArtifact item : artifacts) {
            serviceIds.add(item.getId());
        }
        ArrayList<ArtifactLabel> serviceLabels = new ArrayList<ArtifactLabel>();
        for (String id : serviceIds) {
            serviceLabels.add(ArtifactLabel.createLabelFromService(id));
        }
        return this.getView("listServices").arg("services", serviceLabels).arg("distId", this.ctx.getProperty("distId")).arg("searchFilter", (Object)fulltext);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listExtensionPointsSimple")
    public Object getExtensionPointsSimple() {
        List epIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getExtensionPointIds();
        HashMap<String, Integer> epSimpleIds = new HashMap<String, Integer>();
        ArrayList<ArtifactLabel> labels = new ArrayList<ArtifactLabel>();
        for (String id : epIds) {
            ArtifactLabel label = ArtifactLabel.createLabelFromExtensionPoint(id);
            labels.add(label);
            Integer count = (Integer)epSimpleIds.get(label.simpleId);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            epSimpleIds.put(label.simpleId, count);
        }
        for (ArtifactLabel label : labels) {
            if ((Integer)epSimpleIds.get(label.simpleId) != 1) continue;
            label.label = label.simpleId;
        }
        Collections.sort(labels);
        return this.getView("listExtensionPointsSimple").arg("eps", labels).arg("distId", this.ctx.getProperty("distId")).arg("hideNav", (Object)Boolean.TRUE);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listExtensionPoints")
    public Object getExtensionPoints() {
        List epIds = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getExtensionPointIds();
        ArrayList<ArtifactLabel> labels = new ArrayList<ArtifactLabel>();
        for (String id : epIds) {
            labels.add(ArtifactLabel.createLabelFromExtensionPoint(id));
        }
        Collections.sort(labels);
        return this.getView("listExtensionPoints").arg("eps", labels).arg("distId", this.ctx.getProperty("distId"));
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="filterExtensionPoints")
    public Object filterExtensionPoints() throws Exception {
        String fulltext = this.getContext().getForm().getFormProperty("fulltext");
        List artifacts = this.getSearcher().filterArtifact(this.getContext().getCoreSession(), this.distributionId, "NXExtensionPoint", fulltext);
        ArrayList<String> eps = new ArrayList<String>();
        for (NuxeoArtifact item : artifacts) {
            eps.add(item.getId());
        }
        ArrayList<ArtifactLabel> labels = new ArrayList<ArtifactLabel>();
        for (String id : eps) {
            labels.add(ArtifactLabel.createLabelFromExtensionPoint(id));
        }
        return this.getView("listExtensionPoints").arg("eps", labels).arg("distId", this.ctx.getProperty("distId")).arg("searchFilter", (Object)fulltext);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listContributions")
    public Object getContributions() {
        DistributionSnapshot snapshot = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession());
        List cIds = snapshot.getContributionIds();
        return this.getView("listContributions").arg("cIds", (Object)cIds).arg("contributions", (Object)snapshot.getContributions()).arg("distId", this.ctx.getProperty("distId"));
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="filterContributions")
    public Object filterContributions() throws Exception {
        String fulltext = this.getContext().getForm().getFormProperty("fulltext");
        List artifacts = this.getSearcher().filterArtifact(this.getContext().getCoreSession(), this.distributionId, "NXExtensionPoint", fulltext);
        ArrayList<String> cIds = new ArrayList<String>();
        for (NuxeoArtifact item : artifacts) {
            cIds.add(item.getId());
        }
        return this.getView("listContributions").arg("cIds", cIds).arg("distId", this.ctx.getProperty("distId")).arg("searchFilter", (Object)fulltext);
    }

    @javax.ws.rs.Path(value="doc")
    public Resource viewDoc() {
        try {
            return this.ctx.newObject("documentation", new Object[0]);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="service2Bundle/{serviceId}")
    public Object service2Bundle(@PathParam(value="serviceId") String serviceId) throws Exception {
        ServiceInfo si = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getService(serviceId);
        if (si == null) {
            return null;
        }
        String cid = si.getComponentId();
        ComponentInfo ci = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getComponent(cid);
        String bid = ci.getBundle().getId();
        Path target = new Path(this.getContext().getRoot().getName());
        target = target.append(this.distributionId);
        target = target.append("viewBundle");
        target = target.append(bid + "#Service." + serviceId);
        return Response.seeOther((URI)new URI(target.toString())).build();
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="extensionPoint2Component/{epId}")
    public Object extensionPoint2Component(@PathParam(value="epId") String epId) throws Exception {
        ExtensionPointInfo epi = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession()).getExtensionPoint(epId);
        if (epi == null) {
            return null;
        }
        String cid = epi.getComponent().getId();
        Path target = new Path(this.getContext().getRoot().getName());
        target = target.append(this.distributionId);
        target = target.append("viewComponent");
        target = target.append(cid + "#extensionPoint." + epId);
        return Response.seeOther((URI)new URI(target.toString())).build();
    }

    @javax.ws.rs.Path(value="viewBundle/{bundleId}")
    public Resource viewBundle(@PathParam(value="bundleId") String bundleId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("bundle", new Object[]{bundleId});
            NuxeoArtifact nxItem = wo.getNxArtifact();
            if (nxItem == null) {
                throw new WebResourceNotFoundException(bundleId);
            }
            TreeHelper.updateTree(this.getContext(), nxItem.getHierarchyPath());
            return wo;
        }
        catch (OperationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewComponent/{componentId}")
    public Resource viewComponent(@PathParam(value="componentId") String componentId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("component", new Object[]{componentId});
            NuxeoArtifact nxItem = wo.getNxArtifact();
            if (nxItem == null) {
                throw new WebResourceNotFoundException(componentId);
            }
            TreeHelper.updateTree(this.getContext(), nxItem.getHierarchyPath());
            return wo;
        }
        catch (OperationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewSeamComponent/{componentId}")
    public Resource viewSeamComponent(@PathParam(value="componentId") String componentId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("seamComponent", new Object[]{componentId});
            return wo;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewOperation/{opId}")
    public Resource viewOperation(@PathParam(value="opId") String opId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("operation", new Object[]{opId});
            return wo;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewService/{serviceId}")
    public Resource viewService(@PathParam(value="serviceId") String serviceId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("service", new Object[]{serviceId});
            NuxeoArtifact nxItem = wo.getNxArtifact();
            if (nxItem == null) {
                throw new WebResourceNotFoundException(serviceId);
            }
            TreeHelper.updateTree(this.getContext(), nxItem.getHierarchyPath());
            return wo;
        }
        catch (OperationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewExtensionPoint/{epId}")
    public Resource viewExtensionPoint(@PathParam(value="epId") String epId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("extensionPoint", new Object[]{epId});
            NuxeoArtifact nxItem = wo.getNxArtifact();
            if (nxItem == null) {
                throw new WebResourceNotFoundException(epId);
            }
            TreeHelper.updateTree(this.getContext(), nxItem.getHierarchyPath());
            return wo;
        }
        catch (OperationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewContribution/{cId}")
    public Resource viewContribution(@PathParam(value="cId") String cId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("contribution", new Object[]{cId});
            NuxeoArtifact nxItem = wo.getNxArtifact();
            if (nxItem == null) {
                throw new WebResourceNotFoundException(cId);
            }
            TreeHelper.updateTree(this.getContext(), nxItem.getHierarchyPath());
            return wo;
        }
        catch (OperationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewBundleGroup/{gId}")
    public Resource viewBundleGroup(@PathParam(value="gId") String gId) {
        try {
            NuxeoArtifactWebObject wo = (NuxeoArtifactWebObject)this.ctx.newObject("bundleGroup", new Object[]{gId});
            NuxeoArtifact nxItem = wo.getNxArtifact();
            if (nxItem == null) {
                throw new WebResourceNotFoundException(gId);
            }
            TreeHelper.updateTree(this.getContext(), nxItem.getHierarchyPath());
            return wo;
        }
        catch (OperationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="viewArtifact/{id}")
    public Object viewArtifact(@PathParam(value="id") String id) {
        try {
            DistributionSnapshot snap = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession());
            BundleGroup bg = snap.getBundleGroup(id);
            if (bg != null) {
                return this.viewBundleGroup(id);
            }
            BundleInfo bi = snap.getBundle(id);
            if (bi != null) {
                return this.viewBundle(id);
            }
            ComponentInfo ci = snap.getComponent(id);
            if (ci != null) {
                return this.viewComponent(id);
            }
            ServiceInfo si = snap.getService(id);
            if (si != null) {
                return this.viewService(id);
            }
            ExtensionPointInfo epi = snap.getExtensionPoint(id);
            if (epi != null) {
                return this.viewExtensionPoint(id);
            }
            ExtensionInfo ei = snap.getContribution(id);
            if (ei != null) {
                return this.viewContribution(id);
            }
            return Response.status((int)404).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public String getLabel(String id) {
        return null;
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listSeamComponents")
    public Object listSeamComponents() throws Exception {
        return this.dolistSeamComponents("listSeamComponents", false);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listSeamComponentsSimple")
    public Object listSeamComponentsSimple() throws Exception {
        return this.dolistSeamComponents("listSeamComponentsSimple", true);
    }

    protected Object dolistSeamComponents(String view, boolean hideNav) throws Exception {
        this.getSnapshotManager().initSeamContext(this.getContext().getRequest());
        DistributionSnapshot snap = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession());
        List seamComponents = snap.getSeamComponents();
        return this.getView(view).arg("seamComponents", (Object)seamComponents).arg("distId", this.ctx.getProperty("distId")).arg("hideNav", (Object)hideNav);
    }

    @GET
    @Produces(value={"text/html"})
    @javax.ws.rs.Path(value="listOperations")
    public Object listOperations() throws Exception {
        DistributionSnapshot snap = this.getSnapshotManager().getSnapshot(this.distributionId, this.ctx.getCoreSession());
        List operations = snap.getOperations();
        return this.getView("listOperations").arg("operations", (Object)operations).arg("distId", this.ctx.getProperty("distId")).arg("hideNav", (Object)false);
    }
}

