/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpContentTooLargeException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.owasp.validator.css.CssHandler;
import org.owasp.validator.css.CssScanner;
import org.owasp.validator.html.InternalPolicy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.util.ErrorMessageUtil;
import org.owasp.validator.html.util.HTMLEntityEncoder;
import org.w3c.css.sac.InputSource;

public class ExternalCssScanner
extends CssScanner {
    public ExternalCssScanner(InternalPolicy policy, ResourceBundle messages) {
        super(policy, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseImportedStylesheets(LinkedList stylesheets, CssHandler handler, ArrayList errorMessages, int sizeLimit) throws ScanException {
        int importedStylesheets = 0;
        if (!stylesheets.isEmpty()) {
            HttpClient httpClient = new HttpClient();
            HttpConnectionManagerParams params = httpClient.getHttpConnectionManager().getParams();
            int timeout = 1000;
            try {
                timeout = Integer.parseInt(this.policy.getDirective("connectionTimeout"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            params.setConnectionTimeout(timeout);
            params.setSoTimeout(timeout);
            httpClient.getHttpConnectionManager().setParams(params);
            int allowedImports = 1;
            try {
                allowedImports = Integer.parseInt(this.policy.getDirective("maxStyleSheetImports"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            while (!stylesheets.isEmpty()) {
                URI stylesheetUri = (URI)stylesheets.removeFirst();
                if (++importedStylesheets > allowedImports) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.exceeded", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString()), String.valueOf(allowedImports)}));
                    continue;
                }
                GetMethod stylesheetRequest = new GetMethod(stylesheetUri.toString());
                byte[] stylesheet = null;
                try {
                    httpClient.executeMethod((HttpMethod)stylesheetRequest);
                    stylesheet = stylesheetRequest.getResponseBody(sizeLimit);
                }
                catch (HttpContentTooLargeException hctle) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.toolarge", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString()), String.valueOf(this.policy.getMaxInputSize())}));
                }
                catch (IOException ioe) {
                    errorMessages.add(ErrorMessageUtil.getMessage(this.messages, "error.css.import.failure", new Object[]{HTMLEntityEncoder.htmlEntityEncode(stylesheetUri.toString())}));
                }
                finally {
                    stylesheetRequest.releaseConnection();
                }
                if (stylesheet == null) continue;
                sizeLimit -= stylesheet.length;
                try {
                    InputSource nextStyleSheet = new InputSource((Reader)new InputStreamReader(new ByteArrayInputStream(stylesheet)));
                    this.parser.parseStyleSheet(nextStyleSheet);
                }
                catch (IOException ioe) {
                    throw new ScanException(ioe);
                }
            }
        }
    }
}

