/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.metrics;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

public class MetricInvocationHandler<T>
implements InvocationHandler {
    protected final T proxied;

    protected MetricInvocationHandler(T proxied) {
        this.proxied = proxied;
    }

    public static <T> T newProxy(T proxied, Class<?> ... classes) {
        MetricInvocationHandler<T> handler = new MetricInvocationHandler<T>(proxied);
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), classes, handler);
    }

    protected String formatParms(Object ... parms) {
        if (parms == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (Object parm : parms) {
            buffer.append(".").append(parm);
        }
        return buffer.toString();
    }

    protected String formatName(Method m, Object[] parms) {
        Class<?> declaringClass = m.getDeclaringClass();
        return String.format("%s.%s", declaringClass.getSimpleName(), m.getName());
    }

    protected String formatNote(Method m, Object[] parms) {
        return String.format("%s#%s(%s)", m.getDeclaringClass().getSimpleName(), m.getName(), this.formatParms(parms));
    }

    protected Stopwatch getStopwatch(Method m, Object[] parms) {
        String name = this.formatName(m, parms);
        Stopwatch stopwatch = SimonManager.getStopwatch((String)name);
        stopwatch.setNote(this.formatNote(m, parms));
        return stopwatch;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] parms) throws Throwable {
        Split split = this.getStopwatch(m, parms).start();
        try {
            Object object = m.invoke(this.proxied, parms);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            split.stop();
        }
    }
}

