/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.actions;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.runtime.api.Framework;

@Name(value="richTextEditorActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class RichTextEditorActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RichTextEditorActions.class);

    public String convertToHtml(String text, String mimeType) {
        SimpleBlobHolder bh = new SimpleBlobHolder((Blob)new StringBlob(text, mimeType, "UTF-8"));
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("bodyContentOnly", Boolean.TRUE);
        try {
            bh = ((ConversionService)Framework.getLocalService(ConversionService.class)).convertToMimeType("text/html", (BlobHolder)bh, parameters);
            text = bh.getBlob().getString();
        }
        catch (Exception e) {
            log.error((Object)"Failed to convert to HTML.", (Throwable)e);
        }
        return text;
    }
}

