/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.QueryException;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.security.SecurityException;

public interface Session {
    public static final String USER_NAME = "username";

    public String getSessionId();

    public String getRepositoryName();

    public DocumentModelList query(String var1, String var2, QueryFilter var3, long var4) throws QueryException;

    public IterableQueryResult queryAndFetch(String var1, String var2, QueryFilter var3, Object[] var4) throws QueryException;

    public void save() throws DocumentException;

    public boolean isLive();

    public boolean isStateSharedByAllThreadSessions();

    public void close();

    public Document resolvePath(String var1) throws DocumentException;

    public Document getDocumentByUUID(String var1) throws DocumentException;

    public Document getRootDocument() throws DocumentException;

    public Document getNullDocument() throws DocumentException;

    public Document copy(Document var1, Document var2, String var3) throws DocumentException;

    public Document move(Document var1, Document var2, String var3) throws DocumentException;

    public Document createProxy(Document var1, Document var2) throws DocumentException;

    public Collection<Document> getProxies(Document var1, Document var2) throws DocumentException;

    public void setProxyTarget(Document var1, Document var2) throws DocumentException;

    public Document importDocument(String var1, Document var2, String var3, String var4, Map<String, Serializable> var5) throws DocumentException;

    public Document getVersion(String var1, VersionModel var2) throws DocumentException;

    public boolean isNegativeAclAllowed();

    public ACP getMergedACP(Document var1) throws SecurityException;

    public void setACP(Document var1, ACP var2, boolean var3) throws DocumentException;

    public Map<String, String> getBinaryFulltext(String var1) throws DocumentException;
}

