/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMonitor;
import com.sun.jdmk.discovery.DiscoveryResponderNotification;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.management.remote.JMXServiceURL;

class ActualMonitor
extends DiscoveryCommon
implements Serializable {
    private static final long serialVersionUID = 3370752883861960954L;
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "ActualMonitor");
    private static long sequenceNumber = 0L;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private Thread listeningThread = null;
    private volatile boolean stopRequested = false;
    private transient int state = 1;
    private transient DiscoveryMonitor monitor = null;
    private Vector listeners = new Vector();
    private final int[] lock = new int[0];

    public ActualMonitor(String multicastGroup, int multicastPort, DiscoveryMonitor monitor) throws IOException {
        super(multicastGroup, multicastPort);
        this.localClassName = "com.sun.jdmk.discovery.ActualMonitor";
        if (this.logger.finerOn()) {
            this.logger.finer("constructor ", "initialize multicast socket");
        }
        this.multicastGroup = multicastGroup;
        this.multicastPort = multicastPort;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block12: {
            if (this.logger.finerOn()) {
                this.logger.finer("run ", "start");
            }
            try {
                this.connectToGroup();
                ** GOTO lbl28
            }
            catch (IOException e) {
                var2_5 = this.lock;
                // MONITORENTER : this.lock
                this.stopRequested = true;
                // MONITOREXIT : var2_5
                if (true) ** GOTO lbl28
            }
            do {
                this.monitor.changeState(0);
                try {
                    if (this.logger.finerOn()) {
                        this.logger.finer("run ", "Start Waiting ");
                    }
                    pdu = (ResponsePDU)this.receiveMsg(this);
                    this.processMsg(pdu);
                }
                catch (Exception e) {
                    if (this.stopped()) break;
                    if (!this.logger.finestOn()) continue;
                    this.logger.finest("run ", "Got exception: " + e.toString(), e);
                }
lbl28:
                // 5 sources

            } while (!this.stopped());
            try {
                this.monitor.changeState(1);
                this.disconnectFromGroup();
                this.close();
            }
            catch (IOException e) {
                if (this.stopped() || !this.logger.finestOn()) break block12;
                this.logger.finest("run ", e);
            }
        }
        if (this.logger.finestOn() == false) return;
        this.logger.finest("run ", "stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            block6: {
                if (this.stopRequested) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.stopRequested = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                try {
                    this.close();
                }
                catch (Exception e) {
                    if (!this.logger.finestOn()) break block6;
                    this.logger.finest("stopMonitor ", "Got exception during closing.", e);
                }
            }
            return;
        }
    }

    private void processMsg(ResponsePDU rcvPDU) throws IOException {
        if (rcvPDU == null) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "received a nul pdu '");
            }
            return;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("processMsg ", "received pdu '" + rcvPDU.printState() + "'");
        }
        if (!rcvPDU.getEvent()) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "not an event message");
            }
            return;
        }
        DiscoveryResponse result = new DiscoveryResponse();
        result.host = rcvPDU.getHost();
        result.mbeanServerId = rcvPDU.getMbeanServerId();
        result.specificationName = rcvPDU.getSpecificationName();
        result.specificationVendor = rcvPDU.getSpecificationVendor();
        result.specificationVersion = rcvPDU.getSpecificationVersion();
        result.implementationName = rcvPDU.getImplementationName();
        result.implementationVendor = rcvPDU.getImplementationVendor();
        result.implementationVersion = rcvPDU.getImplementationVersion();
        result.objectList = rcvPDU.getObjectList();
        result.userData = rcvPDU.getUserData();
        result.serverAddresses = rcvPDU.serverAddresses != null ? rcvPDU.serverAddresses : new JMXServiceURL[0];
        DiscoveryResponderNotification event = new DiscoveryResponderNotification(this.monitor, rcvPDU.getAgentState(), result, sequenceNumber++);
        this.monitor.sendNotification(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopped() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.stopRequested;
        }
    }
}

