/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.interceptor;

import com.sun.jdmk.JdmkMBeanServer;
import com.sun.jdmk.interceptor.InterceptorCycleException;
import com.sun.jdmk.interceptor.InterceptorNotPresentException;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class ForwardingMBeanServerInterceptor
implements MBeanServerInterceptor {
    private MBeanServerInterceptor next;

    protected ForwardingMBeanServerInterceptor() {
    }

    public void setNextInterceptor(MBeanServerInterceptor next) throws NullPointerException, InterceptorCycleException {
        if (next == null) {
            throw new NullPointerException("Null interceptor");
        }
        if (next instanceof ForwardingMBeanServerInterceptor) {
            IdentityHashMap<MBeanServerInterceptor, MBeanServerInterceptor> seen = new IdentityHashMap<MBeanServerInterceptor, MBeanServerInterceptor>();
            MBeanServerInterceptor mbsi = next;
            while (mbsi instanceof ForwardingMBeanServerInterceptor) {
                if (seen.containsKey(mbsi)) {
                    throw new InterceptorCycleException("Would make cycle");
                }
                seen.put(mbsi, mbsi);
                ForwardingMBeanServerInterceptor f = (ForwardingMBeanServerInterceptor)mbsi;
                mbsi = f.getNextInterceptor();
            }
        }
        this.next = next;
    }

    public MBeanServerInterceptor getNextInterceptor() {
        return this.next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFirst(JdmkMBeanServer lmbs) throws NullPointerException, InterceptorCycleException {
        JdmkMBeanServer jdmkMBeanServer = lmbs;
        synchronized (jdmkMBeanServer) {
            MBeanServerInterceptor inter = lmbs.getMBeanServerInterceptor();
            this.setNextInterceptor(inter);
            lmbs.setMBeanServerInterceptor(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLast(JdmkMBeanServer lmbs) throws NullPointerException, InterceptorCycleException {
        JdmkMBeanServer jdmkMBeanServer = lmbs;
        synchronized (jdmkMBeanServer) {
            MBeanServerInterceptor inter = lmbs.getMBeanServerInterceptor();
            if (!(inter instanceof ForwardingMBeanServerInterceptor)) {
                this.insertFirst(lmbs);
                return;
            }
            ForwardingMBeanServerInterceptor finter = (ForwardingMBeanServerInterceptor)inter;
            IdentityHashMap<MBeanServerInterceptor, MBeanServerInterceptor> seen = new IdentityHashMap<MBeanServerInterceptor, MBeanServerInterceptor>();
            while ((inter = finter.getNextInterceptor()) instanceof ForwardingMBeanServerInterceptor) {
                if (seen.containsKey(inter)) {
                    throw new InterceptorCycleException("Existing cycle!");
                }
                seen.put(inter, inter);
                finter = (ForwardingMBeanServerInterceptor)inter;
            }
            this.setNextInterceptor(inter);
            finter.setNextInterceptor(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(JdmkMBeanServer lmbs) throws InterceptorNotPresentException, InterceptorCycleException {
        String msg = "Interceptor not in JdmkMBeanServer chain";
        JdmkMBeanServer jdmkMBeanServer = lmbs;
        synchronized (jdmkMBeanServer) {
            MBeanServerInterceptor inter = lmbs.getMBeanServerInterceptor();
            if (!(inter instanceof ForwardingMBeanServerInterceptor)) {
                throw new InterceptorNotPresentException("Interceptor not in JdmkMBeanServer chain");
            }
            ForwardingMBeanServerInterceptor finter = (ForwardingMBeanServerInterceptor)inter;
            if (finter == this) {
                lmbs.setMBeanServerInterceptor(this.getNextInterceptor());
                return;
            }
            IdentityHashMap<MBeanServerInterceptor, MBeanServerInterceptor> seen = new IdentityHashMap<MBeanServerInterceptor, MBeanServerInterceptor>();
            while (true) {
                if (!((inter = finter.getNextInterceptor()) instanceof ForwardingMBeanServerInterceptor)) {
                    throw new InterceptorNotPresentException("Interceptor not in JdmkMBeanServer chain");
                }
                if (inter == this) break;
                if (seen.containsKey(inter)) {
                    throw new InterceptorCycleException("Existing cycle!");
                }
                seen.put(inter, inter);
                finter = (ForwardingMBeanServerInterceptor)inter;
            }
            finter.setNextInterceptor(this.getNextInterceptor());
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.next.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.next.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.next.registerMBean(object, name);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.next.unregisterMBean(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.next.getObjectInstance(name);
    }

    @Override
    public Set queryMBeans(ObjectName name, QueryExp query) {
        return this.next.queryMBeans(name, query);
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query) {
        return this.next.queryNames(name, query);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.next.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        return this.next.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.next.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.next.getAttributes(name, attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.next.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.next.setAttributes(name, attributes);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.next.invoke(name, operationName, params, signature);
    }

    @Override
    public String getDefaultDomain() {
        return this.next.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.next.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.next.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.next.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.next.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.next.getMBeanInfo(name);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.next.isInstanceOf(name, className);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.next.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.next.getClassLoader(loaderName);
    }

    @Override
    public final ClassLoader getMBeanClassLoader(ObjectName name) throws InstanceNotFoundException {
        return this.getClassLoaderFor(name);
    }
}

