/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tasks;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class DaemonTaskServer
implements TaskServer {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.misc", DaemonTaskServer.class);
    private final Daemon daemon = new Daemon();
    private transient boolean on = false;
    private transient boolean isRunning = false;
    private transient boolean terminating = false;
    private transient LinkedList list = new LinkedList();
    private transient Thread thread = null;
    private transient long sequenceNumber = 0L;
    private static int count = 0;

    private synchronized void running() {
        this.isRunning = true;
    }

    private synchronized void stopped() {
        this.isRunning = false;
        this.thread = null;
    }

    private synchronized boolean isRunning() {
        return this.isRunning;
    }

    private synchronized boolean isOn() {
        return this.on;
    }

    void run() {
        try {
            this.running();
            if (logger.finerOn()) {
                logger.finer("run", "Task Server Thread starting...");
            }
            while (this.isOn()) {
                try {
                    Task t = this.nextTask();
                    if (t == null) continue;
                    this.execute(t);
                }
                catch (InterruptedException i) {
                    if (!logger.finerOn()) continue;
                    logger.finer("run", "Task Server Thread interrupted...");
                }
                catch (Throwable t) {
                    if (logger.fineOn()) {
                        logger.fine("run", "Unexpected Error/Exception in Task Server thread: " + t + "\n\t Error/Exception ignored.");
                    }
                    if (!logger.debugOn()) continue;
                    logger.debug("run", t);
                }
            }
        }
        finally {
            try {
                if (logger.finerOn()) {
                    logger.finer("run", "Task Server Thread exiting...");
                }
            }
            catch (Throwable throwable) {}
            this.stopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Task nextTask() throws InterruptedException {
        try {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                return (Task)this.list.removeFirst();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.wait();
            try {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    return (Task)this.list.removeFirst();
                }
            }
            catch (NoSuchElementException x) {
                return null;
            }
        }
    }

    protected void execute(Task task) throws InterruptedException {
        task.run();
    }

    protected void cancel(Task task) throws InterruptedException {
        task.cancel();
    }

    @Override
    public synchronized void submitTask(Task task) {
        if (this.terminating) {
            throw new IllegalStateException("Task Server Terminated");
        }
        if (task == null) {
            return;
        }
        this.list.addLast(task);
        this.wakethread();
    }

    private final synchronized void wakethread() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Thread t;
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            if (!this.isOn() && this.thread == null) {
                return;
            }
            t = this.thread;
            this.on = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        if (t != null && Thread.currentThread() != t) {
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isListEmpty() {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws InterruptedException {
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            this.terminating = true;
        }
        this.stop();
        daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            while (!this.isListEmpty()) {
                try {
                    Task t;
                    LinkedList linkedList = this.list;
                    synchronized (linkedList) {
                        t = (Task)this.list.removeFirst();
                    }
                    this.cancel(t);
                }
                catch (NoSuchElementException x) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        if (this.isOn() || this.isRunning()) {
            throw new IllegalStateException("Must be stopped in order to reset");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
        this.terminating = false;
    }

    public void start() {
        this.start(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int threadPriority) {
        Thread t;
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            if (this.terminating) {
                throw new IllegalStateException("Task Server Terminated");
            }
            if (this.isOn()) {
                return;
            }
            this.on = true;
            t = this.thread = new Thread((Runnable)this.daemon, "DaemonTaskServer(" + count++ + ")");
            t.setDaemon(true);
            t.setPriority(threadPriority);
        }
        t.start();
    }

    private final class Daemon
    implements Runnable {
        private Daemon() {
        }

        @Override
        public void run() {
            DaemonTaskServer.this.run();
        }
    }
}

