/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.platform.portal.notifications.listener;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.NotificationEventListener;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.runtime.api.Framework;

public class OttcNotificationEventListener
extends NotificationEventListener {
    protected void sendNotificationSignalForUser(Notification notification, String subscriptor, Event event, DocumentEventContext ctx) throws ClientException {
        if ("emailDocumentSend".equals(event.getName())) {
            super.sendNotificationSignalForUser(notification, subscriptor, event, ctx);
        } else if (this.checkRulesForSubscriptor(notification, subscriptor, event, ctx)) {
            super.sendNotificationSignalForUser(notification, subscriptor, event, ctx);
        }
    }

    protected boolean checkRulesForSubscriptor(Notification notification, String subscriptor, Event event, DocumentEventContext ctx) {
        LoginContext loginContext = null;
        CoreSession subscriptorSession = null;
        try {
            loginContext = Framework.loginAsUser((String)subscriptor);
            subscriptorSession = CoreInstance.openCoreSession(null);
            boolean bl = !this.blockUserWhenSubscriptor(ctx, subscriptor);
            return bl;
        }
        catch (LoginException lie) {
            throw new ClientException((Throwable)lie);
        }
        finally {
            if (subscriptorSession != null) {
                CoreInstance.closeCoreSession((CoreSession)subscriptorSession);
            }
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException loe) {
                    throw new ClientException((Throwable)loe);
                }
            }
        }
    }

    protected boolean blockUserWhenSubscriptor(DocumentEventContext ctx, String subscriptor) {
        return StringUtils.equals((String)ctx.getPrincipal().getName(), (String)subscriptor);
    }
}

