/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.css.ECSSVersion;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.ParserCSS21TreeConstants;
import com.phloc.css.parser.ParserCSS30TreeConstants;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(1, 1),
    CHARSET(2, 2),
    UNKNOWNRULE(3, 3),
    STYLERULE(17, 31),
    IMPORTRULE(4, 4),
    PAGERULE(12, 16),
    MEDIARULE(8, 8),
    FONTFACERULE(-1, 46),
    SELECTOR(18, 18),
    STYLEDECLARATION(27, 33),
    DECLARATION(28, 34),
    NAMESPACEPREFIX(19, 20),
    ELEMENTNAME(20, 21),
    HASH(26, 32),
    CLASS(21, 22),
    PSEUDO(25, 26),
    NEGATION(-1, 28),
    ATTRIB(22, 23),
    ATTRIBOPERATOR(23, 24),
    ATTRIBVALUE(24, 25),
    COMBINATOR(15, 19),
    NTH(-1, 27),
    PROPERTY(16, 30),
    IMPORTANT(29, 35),
    EXPR(30, 36),
    TERM(31, 37),
    OPERATOR(14, 29),
    URI(32, 38),
    FUNCTION(33, 39),
    MATH(-1, 40),
    MATH_SUMOPERATOR(-1, 41),
    MATH_PRODUCT(-1, 43),
    MATH_PRODUCTOPERATOR(-1, 42),
    MATH_UNIT(-1, 44),
    MEDIALIST(9, 9),
    MEDIUM(11, 13),
    MEDIAQUERY(-1, 11),
    MEDIAMODIFIER(-1, 12),
    MEDIAEXPR(-1, 14),
    MEDIAFEATURE(-1, 15),
    PSEUDOPAGE(13, 17),
    KEYFRAMESRULE(-1, 47),
    KEYFRAMESIDENTIFIER(-1, 48),
    KEYFRAMESSELECTOR(-1, 49),
    SINGLEKEYFRAMESELECTOR(-1, 50),
    VIEWPORTRULE(-1, 51),
    NAMESPACERULE(5, 5),
    NAMESPACERULEPREFIX(6, 6),
    NAMESPACERULEURL(7, 7),
    ERROR_SKIPTO(0, 0);

    private static final Logger s_aLogger;
    private final int m_nParserType21;
    private final int m_nParserType30;

    private ECSSNodeType(int n2, int n3) {
        this.m_nParserType21 = n2;
        this.m_nParserType30 = n3;
    }

    int getParserNodeType(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS21: {
                return this.m_nParserType21;
            }
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    public boolean isNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return cSSNode.getNodeType() == this.getParserNodeType(eCSSVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS21: {
                return this.m_nParserType21 == -1 ? this.name() : ParserCSS21TreeConstants.jjtNodeName[this.m_nParserType21];
            }
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        for (ECSSNodeType eCSSNodeType : ECSSNodeType.values()) {
            if (!eCSSNodeType.isNode(cSSNode, eCSSVersion)) continue;
            return eCSSNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        ECSSNodeType eCSSNodeType = ECSSNodeType.getNodeType(cSSNode, eCSSVersion);
        if (eCSSNodeType != null) {
            return eCSSNodeType.getNodeName(eCSSVersion);
        }
        s_aLogger.warn("Unsupported node type " + cSSNode.getNodeType() + " in version " + (Object)((Object)eCSSVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion, @Nonnull StringBuilder stringBuilder, @Nonnull String string) {
        stringBuilder.append(string).append(ECSSNodeType.getNodeName(cSSNode, eCSSVersion));
        if (cSSNode.hasText()) {
            stringBuilder.append('[').append(cSSNode.getText()).append(']');
        }
        stringBuilder.append('\n');
        for (CSSNode cSSNode2 : cSSNode) {
            ECSSNodeType._dumpRecursive(cSSNode2, eCSSVersion, stringBuilder, string + "  ");
        }
    }

    @Nonnull
    @Nonempty
    static String getDump(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        StringBuilder stringBuilder = new StringBuilder();
        ECSSNodeType._dumpRecursive(cSSNode, eCSSVersion, stringBuilder, "");
        return stringBuilder.toString();
    }

    static {
        s_aLogger = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

