/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.resources;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.resources.ResourceBank;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

public final class ResourceManager
implements Registrable {
    private static final Log log = LogFactory.getLog(ResourceManager.class);
    public static final String GLOBAL_RESOURCES_REGISTERED_EVENT = "themeGlobalResourcesRegistered";
    private final HashMap<URL, List<String>> globalCache = new HashMap();
    private final ThreadLocal<List<String>> localCache = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private final TypeRegistry typeRegistry = Manager.getTypeRegistry();

    public void addResource(String name, URL themeUrl) {
        this.addResource(name, themeUrl, false);
    }

    public void addResource(String name, URL themeUrl, boolean local) {
        if (local) {
            log.debug((Object)("Added local resource: " + name));
        } else {
            log.debug((Object)("Added theme resource: " + name));
        }
        ResourceType resourceType = (ResourceType)this.typeRegistry.lookup(TypeFamily.RESOURCE, name);
        if (resourceType != null) {
            for (String dependency : resourceType.getDependencies()) {
                log.debug((Object)("  Subresource dependency: " + name + " -> " + dependency));
                this.addResource(dependency, themeUrl, local);
            }
            List<String> scripts = local ? this.getLocalResources() : this.getGlobalResourcesFor(themeUrl);
            if (!scripts.contains(name)) {
                scripts.add(name);
            }
        } else {
            log.warn((Object)("Resource not found: " + name));
        }
    }

    public void flush() {
        this.getLocalResources().clear();
    }

    private List<String> getLocalResources() {
        return this.localCache.get();
    }

    public List<String> getResourcesFor(String themeUrl) {
        ArrayList<String> resources = new ArrayList<String>();
        resources.addAll(this.getGlobalResourcesFor(themeUrl));
        for (String localResource : this.getLocalResources()) {
            if (resources.contains(localResource)) continue;
            resources.add(localResource);
        }
        return resources;
    }

    public List<String> getGlobalResourcesFor(String themeUrl) {
        try {
            return this.getGlobalResourcesFor(new URL(themeUrl));
        }
        catch (MalformedURLException e) {
            log.warn((Object)e);
            return null;
        }
    }

    public synchronized List<String> getGlobalResourcesFor(URL themeUrl) {
        if (!this.globalCache.containsKey(themeUrl)) {
            this.globalCache.put(themeUrl, new ArrayList());
            EventService eventService = (EventService)Framework.getLocalService(EventService.class);
            eventService.sendEvent(new Event("org.nuxeo.theme", GLOBAL_RESOURCES_REGISTERED_EVENT, (Object)this, (Object)themeUrl));
        }
        return this.globalCache.get(themeUrl);
    }

    public void clearGlobalCache(String themeName) {
        ArrayList<URL> toRemove = new ArrayList<URL>();
        for (URL themeUrl : this.globalCache.keySet()) {
            String name = ThemeManager.getThemeNameByUrl(themeUrl);
            if (!themeName.equals(name)) continue;
            toRemove.add(themeUrl);
        }
        for (URL themeUrl : toRemove) {
            this.globalCache.remove(themeUrl);
        }
    }

    public static byte[] getBinaryBankResource(String resourceBankName, String collectionName, String typeName, String resourceName) throws ThemeException {
        byte[] data = null;
        ResourceBank resourceBank = ThemeManager.getResourceBank(resourceBankName);
        data = resourceBank.getResourceContent(collectionName, typeName, resourceName);
        if (data == null) {
            throw new ThemeException("Resource bank content could not be read: " + resourceName);
        }
        return data;
    }

    public static String getBankResource(String resourceBankName, String collectionName, String typeName, String resourceName) throws ThemeException {
        byte[] data = ResourceManager.getBinaryBankResource(resourceBankName, collectionName, typeName, resourceName);
        if (data == null) {
            throw new ThemeException("Could not get bank resource: " + resourceName);
        }
        return new String(data);
    }

    @Override
    public void clear() {
        this.globalCache.clear();
    }
}

