/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.services.infos.provider;

import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProvider;
import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProviderDescriptor;
import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProviderService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class DocumentInformationsProviderServiceImpl
extends DefaultComponent
implements DocumentInformationsProviderService {
    private static final long serialVersionUID = 3212642773317224973L;
    private static final Log log = LogFactory.getLog(DocumentInformationsProviderServiceImpl.class);
    public static final String FETCH_INFOS_EXT_POINT = "fetch_infos";
    public static final String EXTENDED_FETCH_INFOS_EXT_POINT = "extended_fetch_infos";
    private Map<String, DocumentInformationsProvider> infosProvidersRegistry;
    private Map<String, DocumentInformationsProvider> extendedInfosProvidersRegistry;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.infosProvidersRegistry = new HashMap<String, DocumentInformationsProvider>(0);
        this.extendedInfosProvidersRegistry = new HashMap<String, DocumentInformationsProvider>(0);
    }

    public void registerExtension(Extension extension) throws Exception {
        if (FETCH_INFOS_EXT_POINT.equals(extension.getExtensionPoint())) {
            this.registerInfosProvider(extension, this.infosProvidersRegistry);
        } else if (EXTENDED_FETCH_INFOS_EXT_POINT.equals(extension.getExtensionPoint())) {
            this.registerInfosProvider(extension, this.extendedInfosProvidersRegistry);
        }
    }

    private void registerInfosProvider(Extension extension, Map<String, DocumentInformationsProvider> registeredInfosProviders) throws Exception {
        Object[] contributions;
        for (Object contribution : contributions = extension.getContributions()) {
            if (!(contribution instanceof DocumentInformationsProviderDescriptor)) continue;
            DocumentInformationsProviderDescriptor descriptor = (DocumentInformationsProviderDescriptor)contribution;
            if (StringUtils.isNotBlank((String)descriptor.getName())) {
                DocumentInformationsProvider infosProvider = (DocumentInformationsProvider)extension.getContext().loadClass(descriptor.getProviderClassName()).newInstance();
                registeredInfosProviders.put(descriptor.getName(), infosProvider);
                continue;
            }
            log.error((Object)"Can not register an Informations provider which has no name: ".concat(StringUtils.isNotBlank((String)descriptor.getProviderClassName()) ? descriptor.getProviderClassName() : "null"));
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        if (FETCH_INFOS_EXT_POINT.equals(extension.getExtensionPoint())) {
            this.unregisterInfosProvider(extension, this.infosProvidersRegistry);
        } else if (EXTENDED_FETCH_INFOS_EXT_POINT.equals(extension.getExtensionPoint())) {
            this.unregisterInfosProvider(extension, this.extendedInfosProvidersRegistry);
        }
    }

    private void unregisterInfosProvider(Extension extension, Map<String, DocumentInformationsProvider> registeredInfosProviders) {
        Object[] contributions;
        for (Object contribution : contributions = extension.getContributions()) {
            if (!(contribution instanceof DocumentInformationsProviderDescriptor)) continue;
            registeredInfosProviders.remove(((DocumentInformationsProviderDescriptor)contribution).getName());
        }
    }

    @Override
    public Map<String, Object> fetchAllInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>(0);
        for (DocumentInformationsProvider contrib : this.infosProvidersRegistry.values()) {
            infos.putAll(contrib.fetchInfos(coreSession, currentDocument));
        }
        return infos;
    }

    @Override
    public Map<String, Object> fetchAllExtendedInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>(0);
        for (DocumentInformationsProvider contrib : this.extendedInfosProvidersRegistry.values()) {
            long begin = System.currentTimeMillis();
            infos.putAll(contrib.fetchInfos(coreSession, currentDocument));
            if (!log.isTraceEnabled()) continue;
            long end = System.currentTimeMillis();
            log.trace((Object)(" " + contrib.getClass().getName() + ": " + String.valueOf(end - begin) + " ms"));
        }
        return infos;
    }
}

