/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.indices.fielddata.breaker.FieldDataBreakerStats;
import org.elasticsearch.monitor.fs.FsStats;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.monitor.network.NetworkStats;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.threadpool.ThreadPoolStats;
import org.elasticsearch.transport.TransportStats;

public class NodeStats
extends NodeOperationResponse
implements ToXContent {
    private long timestamp;
    @Nullable
    private NodeIndicesStats indices;
    @Nullable
    private OsStats os;
    @Nullable
    private ProcessStats process;
    @Nullable
    private JvmStats jvm;
    @Nullable
    private ThreadPoolStats threadPool;
    @Nullable
    private NetworkStats network;
    @Nullable
    private FsStats fs;
    @Nullable
    private TransportStats transport;
    @Nullable
    private HttpStats http;
    @Nullable
    private FieldDataBreakerStats breaker;

    NodeStats() {
    }

    public NodeStats(DiscoveryNode node, long timestamp, @Nullable NodeIndicesStats indices, @Nullable OsStats os, @Nullable ProcessStats process, @Nullable JvmStats jvm, @Nullable ThreadPoolStats threadPool, @Nullable NetworkStats network, @Nullable FsStats fs, @Nullable TransportStats transport, @Nullable HttpStats http, @Nullable FieldDataBreakerStats breaker) {
        super(node);
        this.timestamp = timestamp;
        this.indices = indices;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.network = network;
        this.fs = fs;
        this.transport = transport;
        this.http = http;
        this.breaker = breaker;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    @Nullable
    public NodeIndicesStats getIndices() {
        return this.indices;
    }

    @Nullable
    public OsStats getOs() {
        return this.os;
    }

    @Nullable
    public ProcessStats getProcess() {
        return this.process;
    }

    @Nullable
    public JvmStats getJvm() {
        return this.jvm;
    }

    @Nullable
    public ThreadPoolStats getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public NetworkStats getNetwork() {
        return this.network;
    }

    @Nullable
    public FsStats getFs() {
        return this.fs;
    }

    @Nullable
    public TransportStats getTransport() {
        return this.transport;
    }

    @Nullable
    public HttpStats getHttp() {
        return this.http;
    }

    @Nullable
    public FieldDataBreakerStats getBreaker() {
        return this.breaker;
    }

    public static NodeStats readNodeStats(StreamInput in) throws IOException {
        NodeStats nodeInfo = new NodeStats();
        nodeInfo.readFrom(in);
        return nodeInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.indices = NodeIndicesStats.readIndicesStats(in);
        }
        if (in.readBoolean()) {
            this.os = OsStats.readOsStats(in);
        }
        if (in.readBoolean()) {
            this.process = ProcessStats.readProcessStats(in);
        }
        if (in.readBoolean()) {
            this.jvm = JvmStats.readJvmStats(in);
        }
        if (in.readBoolean()) {
            this.threadPool = ThreadPoolStats.readThreadPoolStats(in);
        }
        if (in.readBoolean()) {
            this.network = NetworkStats.readNetworkStats(in);
        }
        if (in.readBoolean()) {
            this.fs = FsStats.readFsStats(in);
        }
        if (in.readBoolean()) {
            this.transport = TransportStats.readTransportStats(in);
        }
        if (in.readBoolean()) {
            this.http = HttpStats.readHttpStats(in);
        }
        this.breaker = FieldDataBreakerStats.readOptionalCircuitBreakerStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        if (this.indices == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indices.writeTo(out);
        }
        if (this.os == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.os.writeTo(out);
        }
        if (this.process == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.process.writeTo(out);
        }
        if (this.jvm == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.jvm.writeTo(out);
        }
        if (this.threadPool == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.threadPool.writeTo(out);
        }
        if (this.network == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.network.writeTo(out);
        }
        if (this.fs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.fs.writeTo(out);
        }
        if (this.transport == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.transport.writeTo(out);
        }
        if (this.http == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.http.writeTo(out);
        }
        out.writeOptionalStreamable(this.breaker);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!params.param("node_info_format", "default").equals("none")) {
            builder.field("name", this.getNode().name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("transport_address", this.getNode().address().toString(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("host", this.getNode().getHostName(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("ip", new Object[]{this.getNode().getAddress(), XContentBuilder.FieldCaseConversion.NONE});
            if (!this.getNode().attributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry attr : this.getNode().attributes().entrySet()) {
                    builder.field((String)attr.getKey(), (String)attr.getValue(), XContentBuilder.FieldCaseConversion.NONE);
                }
                builder.endObject();
            }
        }
        if (this.getIndices() != null) {
            this.getIndices().toXContent(builder, params);
        }
        if (this.getOs() != null) {
            this.getOs().toXContent(builder, params);
        }
        if (this.getProcess() != null) {
            this.getProcess().toXContent(builder, params);
        }
        if (this.getJvm() != null) {
            this.getJvm().toXContent(builder, params);
        }
        if (this.getThreadPool() != null) {
            this.getThreadPool().toXContent(builder, params);
        }
        if (this.getNetwork() != null) {
            this.getNetwork().toXContent(builder, params);
        }
        if (this.getFs() != null) {
            this.getFs().toXContent(builder, params);
        }
        if (this.getTransport() != null) {
            this.getTransport().toXContent(builder, params);
        }
        if (this.getHttp() != null) {
            this.getHttp().toXContent(builder, params);
        }
        if (this.getBreaker() != null) {
            this.getBreaker().toXContent(builder, params);
        }
        return builder;
    }
}

