/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpTransport
extends HttpTransport {
    private Set<String> supportedMethods;

    public MockHttpTransport() {
    }

    protected MockHttpTransport(Set<String> supportedMethods) {
        this.supportedMethods = supportedMethods;
    }

    @Override
    public boolean supportsMethod(String method) throws IOException {
        return this.supportedMethods == null || this.supportedMethods.contains(method);
    }

    @Override
    protected LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        Preconditions.checkArgument((boolean)this.supportsMethod(method), (String)"HTTP method %s not supported", (Object[])new Object[]{method});
        return new MockLowLevelHttpRequest(url);
    }

    public final Set<String> getSupportedMethods() {
        return this.supportedMethods == null ? null : Collections.unmodifiableSet(this.supportedMethods);
    }

    @Override
    @Deprecated
    public LowLevelHttpRequest buildDeleteRequest(String url) throws IOException {
        return super.buildDeleteRequest(url);
    }

    @Override
    @Deprecated
    public LowLevelHttpRequest buildGetRequest(String url) throws IOException {
        return super.buildGetRequest(url);
    }

    @Override
    @Deprecated
    public LowLevelHttpRequest buildHeadRequest(String url) throws IOException {
        return super.buildHeadRequest(url);
    }

    @Override
    @Deprecated
    public LowLevelHttpRequest buildPatchRequest(String url) throws IOException {
        return super.buildPatchRequest(url);
    }

    @Override
    @Deprecated
    public LowLevelHttpRequest buildPostRequest(String url) throws IOException {
        return super.buildPostRequest(url);
    }

    @Override
    @Deprecated
    public LowLevelHttpRequest buildPutRequest(String url) throws IOException {
        return super.buildPutRequest(url);
    }

    @Override
    @Deprecated
    public boolean supportsHead() throws IOException {
        return super.supportsHead();
    }

    @Override
    @Deprecated
    public boolean supportsPatch() throws IOException {
        return super.supportsPatch();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private Set<String> supportedMethods;

        protected Builder() {
        }

        public MockHttpTransport build() {
            return new MockHttpTransport(this.supportedMethods);
        }

        public final Set<String> getSupportedMethods() {
            return this.supportedMethods;
        }

        public final Builder setSupportedMethods(Set<String> supportedMethods) {
            this.supportedMethods = supportedMethods;
            return this;
        }
    }
}

