/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.wiki;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.ecm.platform.rendering.fm.adapters.ComplexPropertyTemplate;
import org.nuxeo.ecm.platform.rendering.wiki.WikiSerializer;
import org.nuxeo.ecm.platform.rendering.wiki.extensions.FreemarkerMacro;

public class WikiTransformer
implements TemplateDirectiveModel {
    protected final WikiSerializer serializer;

    public WikiTransformer() {
        this(new WikiSerializer());
    }

    public WikiTransformer(WikiSerializer serializer) {
        this.serializer = serializer;
        this.serializer.registerMacro(new FreemarkerMacro());
    }

    public WikiSerializer getSerializer() {
        return this.serializer;
    }

    public void transform(Reader reader, Writer writer) throws RenderingException {
        try {
            this.serializer.serialize(reader, writer);
        }
        catch (Exception e) {
            throw new RenderingException(e);
        }
    }

    public void transform(URL url, Writer writer) throws RenderingException {
        Reader reader = null;
        try {
            InputStream in = url.openStream();
            reader = new BufferedReader(new InputStreamReader(in));
            this.transform(reader, writer);
        }
        catch (Exception e) {
            throw new RenderingException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        block12: {
            FreemarkerEngine engine;
            String syntax = null;
            SimpleScalar scalar = (SimpleScalar)params.get("syntax");
            if (scalar != null) {
                syntax = scalar.getAsString();
            }
            scalar = (SimpleScalar)params.get("src");
            String src = null;
            if (scalar != null) {
                src = scalar.getAsString();
            }
            ComplexPropertyTemplate complex = (ComplexPropertyTemplate)params.get("property");
            Property property = null;
            if (complex != null) {
                property = (Property)complex.getAdaptedObject(null);
            }
            if ((engine = (FreemarkerEngine)env.getCustomAttribute("NX_RENDERING_ENGINE")) == null) {
                throw new TemplateModelException("Not in a nuxeo rendering context");
            }
            try {
                if (property != null) {
                    throw new UnsupportedOperationException("Not Yet Implemented");
                }
                if (src == null) {
                    if (body == null) {
                        throw new TemplateModelException("Transform directive must have either a content either a valid 'src' attribute");
                    }
                    StringWriter writer = new StringWriter();
                    body.render((Writer)writer);
                    String content = writer.getBuffer().toString();
                    this.transform(new StringReader(content), env.getOut());
                    break block12;
                }
                if (src.contains(":/")) {
                    URL url = engine.getResourceLocator().getResourceURL(src);
                    if (url != null) {
                        this.transform(url, env.getOut());
                        break block12;
                    }
                    throw new IllegalArgumentException("Cannot resolve the src attribute: " + src);
                }
                File file = engine.getResourceLocator().getResourceFile(src);
                if (file != null) {
                    this.transform(file.toURI().toURL(), env.getOut());
                    break block12;
                }
                throw new IllegalArgumentException("Cannot resolve the src attribute: " + src);
            }
            catch (RenderingException e) {
                throw new TemplateException("Running wiki transformer failed", (Exception)e, env);
            }
        }
    }
}

