/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.server.impl.atompub.CmisAtomPubServlet;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.opencmis.bindings.NuxeoCmisErrorHelper;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuxeoCmisAtomPubServlet
extends CmisAtomPubServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NuxeoCmisAtomPubServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String baseUrl = VirtualHostHelper.getBaseURL((ServletRequest)request);
        if (baseUrl != null) {
            baseUrl = StringUtils.stripEnd((String)baseUrl, (String)"/") + request.getServletPath() + "/" + "{repositoryId}" + "/";
            request.setAttribute("org.apache.chemistry.opencmis.baseurl", (Object)baseUrl);
        }
        super.service(request, response);
    }

    protected NuxeoCmisErrorHelper.ErrorInfo extractError(Exception ex) {
        return NuxeoCmisErrorHelper.extractError(ex);
    }

    protected void printError(Exception ex, HttpServletResponse response) {
        NuxeoCmisErrorHelper.ErrorInfo errorInfo = this.extractError(ex);
        if (response.isCommitted()) {
            LOG.warn("Failed to send error message to client. Response is already committed.", (Throwable)ex);
            return;
        }
        try {
            response.resetBuffer();
            response.setStatus(errorInfo.statusCode);
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            pw.print("<html><head><title>Apache Chemistry OpenCMIS - " + errorInfo.exceptionName + " error</title><style><!--H1 {font-size:24px;line-height:normal;font-weight:bold;background-color:#f0f0f0;color:#003366;border-bottom:1px solid #3c78b5;padding:2px;} BODY {font-family:Verdana,arial,sans-serif;color:black;font-size:14px;} HR {color:#3c78b5;height:1px;}--></style></head><body>");
            pw.print("<h1>HTTP Status " + errorInfo.statusCode + " - <!--exception-->" + errorInfo.exceptionName + "<!--/exception--></h1>");
            pw.print("<p><!--message-->" + StringEscapeUtils.escapeHtml((String)errorInfo.message) + "<!--/message--></p>");
            String st = ExceptionHelper.getStacktraceAsString((Throwable)ex);
            if (st != null) {
                pw.print("<hr noshade='noshade'/><!--stacktrace--><pre>\n" + st + "\n</pre><!--/stacktrace--><hr noshade='noshade'/>");
            }
            pw.print("</body></html>");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                response.sendError(errorInfo.statusCode, errorInfo.message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

