/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.equals.EqualsImplementationRegistry;
import com.phloc.commons.equals.IEqualsImplementation;
import com.phloc.commons.equals.IEqualsImplementationRegistrarSPI;
import com.phloc.commons.equals.IEqualsImplementationRegistry;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.system.EJavaVersion;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultEqualsImplementationRegistrarSPI
implements IEqualsImplementationRegistrarSPI {
    @Override
    public void registerEqualsImplementations(@Nonnull IEqualsImplementationRegistry iEqualsImplementationRegistry) {
        iEqualsImplementationRegistry.registerEqualsImplementation(BigDecimal.class, new EqualsImplementationBigDecimal());
        iEqualsImplementationRegistry.registerEqualsImplementation(Double.class, new EqualsImplementationDouble());
        iEqualsImplementationRegistry.registerEqualsImplementation(Float.class, new EqualsImplementationFloat());
        iEqualsImplementationRegistry.registerEqualsImplementation(StringBuffer.class, new EqualsImplementationStringBuffer());
        iEqualsImplementationRegistry.registerEqualsImplementation(StringBuilder.class, new EqualsImplementationStringBuilder());
        iEqualsImplementationRegistry.registerEqualsImplementation(Node.class, new EqualsImplementationNode());
        iEqualsImplementationRegistry.registerEqualsImplementation(URL.class, new EqualsImplementationURL());
        iEqualsImplementationRegistry.registerEqualsImplementation(AtomicBoolean.class, new EqualsImplementationAtomicBoolean());
        iEqualsImplementationRegistry.registerEqualsImplementation(AtomicInteger.class, new EqualsImplementationAtomicInteger());
        iEqualsImplementationRegistry.registerEqualsImplementation(AtomicLong.class, new EqualsImplementationAtomicLong());
        iEqualsImplementationRegistry.registerEqualsImplementation(boolean[].class, new EqualsImplementationArrayBoolean());
        iEqualsImplementationRegistry.registerEqualsImplementation(byte[].class, new EqualsImplementationArrayByte());
        iEqualsImplementationRegistry.registerEqualsImplementation(char[].class, new EqualsImplementationArrayChar());
        iEqualsImplementationRegistry.registerEqualsImplementation(double[].class, new EqualsImplementationArrayDouble());
        iEqualsImplementationRegistry.registerEqualsImplementation(float[].class, new EqualsImplementationArrayFloat());
        iEqualsImplementationRegistry.registerEqualsImplementation(int[].class, new EqualsImplementationArrayInt());
        iEqualsImplementationRegistry.registerEqualsImplementation(long[].class, new EqualsImplementationArrayLong());
        iEqualsImplementationRegistry.registerEqualsImplementation(short[].class, new EqualsImplementationArrayShort());
        iEqualsImplementationRegistry.registerEqualsImplementation(Map.class, new EqualsImplementationMap());
        iEqualsImplementationRegistry.registerEqualsImplementation(Collection.class, new EqualsImplementationCollection());
        iEqualsImplementationRegistry.registerEqualsImplementation(Iterator.class, new EqualsImplementationIterator());
        iEqualsImplementationRegistry.registerEqualsImplementation(Enumeration.class, new EqualsImplementationEnumeration());
        iEqualsImplementationRegistry.registerEqualsImplementation(File.class, new EqualsImplementationFile());
        if (EJavaVersion.JDK_17.isSupportedVersion()) {
            iEqualsImplementationRegistry.registerEqualsImplementation(Locale.class, new EqualsImplementationLocale());
        }
    }

    private static final class EqualsImplementationLocale
    implements IEqualsImplementation {
        private EqualsImplementationLocale() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Locale locale = (Locale)object;
            Locale locale2 = (Locale)object2;
            return locale.toString().equals(locale2.toString());
        }
    }

    private static final class EqualsImplementationBigDecimal
    implements IEqualsImplementation {
        private EqualsImplementationBigDecimal() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            BigDecimal bigDecimal = (BigDecimal)object;
            BigDecimal bigDecimal2 = (BigDecimal)object2;
            return bigDecimal.compareTo(bigDecimal2) == 0;
        }
    }

    private static final class EqualsImplementationDouble
    implements IEqualsImplementation {
        private EqualsImplementationDouble() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Double d = (Double)object;
            Double d2 = (Double)object2;
            return d.compareTo(d2) == 0;
        }
    }

    private static final class EqualsImplementationFloat
    implements IEqualsImplementation {
        private EqualsImplementationFloat() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Float f = (Float)object;
            Float f2 = (Float)object2;
            return f.compareTo(f2) == 0;
        }
    }

    private static final class EqualsImplementationStringBuffer
    implements IEqualsImplementation {
        private EqualsImplementationStringBuffer() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return object.toString().equals(object2.toString());
        }
    }

    private static final class EqualsImplementationStringBuilder
    implements IEqualsImplementation {
        private EqualsImplementationStringBuilder() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return object.toString().equals(object2.toString());
        }
    }

    private static final class EqualsImplementationNode
    implements IEqualsImplementation {
        private EqualsImplementationNode() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Node node = (Node)object;
            Node node2 = (Node)object2;
            if (node.getNodeType() != node2.getNodeType()) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getNodeName(), node2.getNodeName())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getLocalName(), node2.getLocalName())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getNamespaceURI(), node2.getNamespaceURI())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getPrefix(), node2.getPrefix())) {
                return false;
            }
            if (!EqualsImplementationRegistry.areEqual(node.getNodeValue(), node2.getNodeValue())) {
                return false;
            }
            NodeList nodeList = node.getChildNodes();
            NodeList nodeList2 = node2.getChildNodes();
            int n = nodeList.getLength();
            if (n != nodeList2.getLength()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Node node3;
                Node node4 = nodeList.item(i);
                if (EqualsImplementationRegistry.areEqual(node4, node3 = nodeList2.item(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static final class EqualsImplementationURL
    implements IEqualsImplementation {
        private EqualsImplementationURL() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            URL uRL = (URL)object;
            URL uRL2 = (URL)object2;
            return uRL.toExternalForm().equals(uRL2.toExternalForm());
        }
    }

    private static final class EqualsImplementationAtomicBoolean
    implements IEqualsImplementation {
        private EqualsImplementationAtomicBoolean() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            AtomicBoolean atomicBoolean = (AtomicBoolean)object;
            AtomicBoolean atomicBoolean2 = (AtomicBoolean)object2;
            return atomicBoolean.get() == atomicBoolean2.get();
        }
    }

    private static final class EqualsImplementationAtomicInteger
    implements IEqualsImplementation {
        private EqualsImplementationAtomicInteger() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            AtomicInteger atomicInteger = (AtomicInteger)object;
            AtomicInteger atomicInteger2 = (AtomicInteger)object2;
            return atomicInteger.get() == atomicInteger2.get();
        }
    }

    private static final class EqualsImplementationAtomicLong
    implements IEqualsImplementation {
        private EqualsImplementationAtomicLong() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            AtomicLong atomicLong = (AtomicLong)object;
            AtomicLong atomicLong2 = (AtomicLong)object2;
            return atomicLong.get() == atomicLong2.get();
        }
    }

    private static final class EqualsImplementationArrayBoolean
    implements IEqualsImplementation {
        private EqualsImplementationArrayBoolean() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
    }

    private static final class EqualsImplementationArrayByte
    implements IEqualsImplementation {
        private EqualsImplementationArrayByte() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
    }

    private static final class EqualsImplementationArrayChar
    implements IEqualsImplementation {
        private EqualsImplementationArrayChar() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((char[])object, (char[])object2);
        }
    }

    private static final class EqualsImplementationArrayDouble
    implements IEqualsImplementation {
        private EqualsImplementationArrayDouble() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((double[])object, (double[])object2);
        }
    }

    private static final class EqualsImplementationArrayFloat
    implements IEqualsImplementation {
        private EqualsImplementationArrayFloat() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((float[])object, (float[])object2);
        }
    }

    private static final class EqualsImplementationArrayInt
    implements IEqualsImplementation {
        private EqualsImplementationArrayInt() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((int[])object, (int[])object2);
        }
    }

    private static final class EqualsImplementationArrayLong
    implements IEqualsImplementation {
        private EqualsImplementationArrayLong() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((long[])object, (long[])object2);
        }
    }

    private static final class EqualsImplementationArrayShort
    implements IEqualsImplementation {
        private EqualsImplementationArrayShort() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            return Arrays.equals((short[])object, (short[])object2);
        }
    }

    private static final class EqualsImplementationMap
    implements IEqualsImplementation {
        private EqualsImplementationMap() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Map map = (Map)object;
            Map map2 = (Map)object2;
            if (map.size() != map2.size()) {
                return false;
            }
            for (Map.Entry entry : map.entrySet()) {
                Object v;
                Object k = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map2.get(k) != null || !map2.containsKey(k) : !EqualsImplementationRegistry.areEqual(v2, v = map2.get(k)))) continue;
                return false;
            }
            return true;
        }
    }

    private static final class EqualsImplementationCollection
    implements IEqualsImplementation {
        private EqualsImplementationCollection() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Collection collection = (Collection)object;
            Collection collection2 = (Collection)object2;
            if (collection.size() != collection2.size()) {
                return false;
            }
            Object[] objectArray = collection.toArray();
            Object[] objectArray2 = collection2.toArray();
            return EqualsImplementationRegistry.areEqual(objectArray, objectArray2);
        }
    }

    private static final class EqualsImplementationIterator
    implements IEqualsImplementation {
        private EqualsImplementationIterator() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Iterator iterator = (Iterator)object;
            Iterator iterator2 = (Iterator)object2;
            while (iterator.hasNext()) {
                Object e;
                if (!iterator2.hasNext()) {
                    return false;
                }
                Object e2 = iterator.next();
                if (EqualsImplementationRegistry.areEqual(e2, e = iterator2.next())) continue;
                return false;
            }
            return !iterator2.hasNext();
        }
    }

    private static final class EqualsImplementationEnumeration
    implements IEqualsImplementation {
        private EqualsImplementationEnumeration() {
        }

        @Override
        public boolean areEqual(Object object, Object object2) {
            Enumeration enumeration = (Enumeration)object;
            Enumeration enumeration2 = (Enumeration)object2;
            while (enumeration.hasMoreElements()) {
                Object e;
                if (!enumeration2.hasMoreElements()) {
                    return false;
                }
                Object e2 = enumeration.nextElement();
                if (EqualsImplementationRegistry.areEqual(e2, e = enumeration2.nextElement())) continue;
                return false;
            }
            return !enumeration2.hasMoreElements();
        }
    }

    private static final class EqualsImplementationFile
    implements IEqualsImplementation {
        private EqualsImplementationFile() {
        }

        @Override
        public boolean areEqual(@Nonnull Object object, @Nonnull Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return FilenameHelper.getCleanPath(file.getAbsoluteFile()).equals(FilenameHelper.getCleanPath(file2.getAbsoluteFile()));
        }
    }
}

