/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractDataScroller;
import org.richfaces.component.DataScrollerControlsMode;
import org.richfaces.event.DataScrollEvent;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.ControlsState;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.AjaxRendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="datascroller.js"), @ResourceDependency(library="org.richfaces", name="datascroller.ecss")})
public class DataScrollerBaseRenderer
extends RendererBase {
    public void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String param = (String)paramMap.get((clientId = component.getClientId(context)) + ":page");
        if (param != null) {
            AbstractDataScroller scroller = (AbstractDataScroller)component;
            int newPage = scroller.getPageForFacet(param);
            int page = scroller.getPage();
            if (newPage != 0 && newPage != page) {
                new DataScrollEvent((UIComponent)scroller, String.valueOf(page), param, newPage).queue();
            }
        }
    }

    protected boolean shouldRender(UIComponent component) {
        AbstractDataScroller ds = (AbstractDataScroller)component;
        return ds.getPageCount() != 1 || ds.isRenderIfSinglePage();
    }

    private DataScrollerControlsMode getModeOrDefault(UIComponent component, String attributeName) {
        DataScrollerControlsMode mode = (DataScrollerControlsMode)((Object)component.getAttributes().get(attributeName));
        if (mode == null) {
            mode = DataScrollerControlsMode.DEFAULT;
        }
        return mode;
    }

    public ControlsState getControlsState(FacesContext context, UIComponent component) {
        int fastStep = (Integer)component.getAttributes().get("fastStepOrDefault");
        int pageIndex = (Integer)component.getAttributes().get("page");
        int pageCount = (Integer)component.getAttributes().get("pageCount");
        int minPageIdx = 1;
        int maxPageIdx = pageCount;
        boolean useFirst = true;
        boolean useLast = true;
        boolean useBackFast = true;
        boolean useForwFast = true;
        ControlsState controlsState = new ControlsState();
        if (pageIndex <= minPageIdx) {
            useFirst = false;
        }
        if (pageIndex >= maxPageIdx) {
            useLast = false;
        }
        if (pageIndex - fastStep < minPageIdx) {
            useBackFast = false;
        }
        if (pageIndex + fastStep > maxPageIdx) {
            useForwFast = false;
        }
        DataScrollerControlsMode boundaryControls = this.getModeOrDefault(component, "boundaryControls");
        DataScrollerControlsMode stepControls = this.getModeOrDefault(component, "stepControls");
        DataScrollerControlsMode fastControls = this.getModeOrDefault(component, "fastControls");
        boolean isAuto = DataScrollerControlsMode.auto.equals((Object)boundaryControls);
        if (isAuto || DataScrollerControlsMode.show.equals((Object)boundaryControls)) {
            if (isAuto) {
                controlsState.setFirstRendered(useFirst);
                controlsState.setLastRendered(useLast);
            }
            controlsState.setFirstEnabled(useFirst);
            controlsState.setLastEnabled(useLast);
        } else {
            controlsState.setFirstRendered(false);
            controlsState.setLastRendered(false);
        }
        isAuto = DataScrollerControlsMode.auto.equals((Object)stepControls);
        if (isAuto || DataScrollerControlsMode.show.equals((Object)stepControls)) {
            if (isAuto) {
                controlsState.setPreviousRendered(useFirst);
                controlsState.setNextRendered(useLast);
            }
            controlsState.setPreviousEnabled(useFirst);
            controlsState.setNextEnabled(useLast);
        } else {
            controlsState.setPreviousRendered(false);
            controlsState.setNextRendered(false);
        }
        isAuto = DataScrollerControlsMode.auto.equals((Object)fastControls);
        if (isAuto || DataScrollerControlsMode.show.equals((Object)fastControls)) {
            if (isAuto) {
                controlsState.setFastForwardRendered(useForwFast);
                controlsState.setFastRewindRendered(useBackFast);
            }
            controlsState.setFastForwardEnabled(useForwFast);
            controlsState.setFastRewindEnabled(useBackFast);
        } else {
            controlsState.setFastForwardRendered(false);
            controlsState.setFastRewindRendered(false);
        }
        UIComponent controlsSeparatorFacet = component.getFacet("controlsSeparator");
        if (controlsSeparatorFacet != null && controlsSeparatorFacet.isRendered()) {
            controlsState.setControlsSeparatorRendered(true);
        }
        return controlsState;
    }

    public Map<String, String> renderPager(ResponseWriter out, FacesContext context, UIComponent component) throws IOException {
        int start;
        int pages;
        int currentPage = (Integer)component.getAttributes().get("page");
        int maxPages = (Integer)component.getAttributes().get("maxPagesOrDefault");
        int pageCount = (Integer)component.getAttributes().get("pageCount");
        HashMap<String, String> digital = new HashMap<String, String>();
        if (pageCount <= 1) {
            return digital;
        }
        int delta = maxPages / 2;
        if (pageCount > maxPages && currentPage > delta) {
            pages = maxPages;
            start = currentPage - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        String clientId = component.getClientId(context);
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            String style;
            String styleClass;
            boolean isCurrentPage;
            boolean bl = isCurrentPage = i + 1 == currentPage;
            if (isCurrentPage) {
                styleClass = (String)component.getAttributes().get("selectedStyleClass");
                style = (String)component.getAttributes().get("selectedStyle");
            } else {
                styleClass = (String)component.getAttributes().get("inactiveStyleClass");
                style = (String)component.getAttributes().get("inactiveStyle");
            }
            if (styleClass == null) {
                styleClass = "";
            }
            if (isCurrentPage) {
                out.startElement("span", component);
                out.writeAttribute("class", (Object)("rf-ds-nmb-btn rf-ds-act " + styleClass), null);
            } else {
                out.startElement("a", component);
                out.writeAttribute("class", (Object)("rf-ds-nmb-btn " + styleClass), null);
                out.writeAttribute("href", (Object)"javascript:void(0);", null);
            }
            if (null != style) {
                out.writeAttribute("style", (Object)style, null);
            }
            String page = Integer.toString(i + 1);
            String id = clientId + "_ds_" + page;
            out.writeAttribute("id", (Object)id, null);
            digital.put(id, page);
            out.writeText((Object)page, null);
            if (isCurrentPage) {
                out.endElement("span");
                continue;
            }
            out.endElement("a");
        }
        return digital;
    }

    public Map<String, Map<String, String>> getControls(FacesContext context, UIComponent component, ControlsState controlsState) {
        HashMap<String, Map<String, String>> controls = new HashMap<String, Map<String, String>>();
        HashMap<String, String> right = new HashMap<String, String>();
        HashMap<String, String> left = new HashMap<String, String>();
        String clientId = component.getClientId(context);
        if (controlsState.getFirstRendered() && controlsState.getFirstEnabled()) {
            left.put(clientId + "_ds_f", "first");
        }
        if (controlsState.getFastRewindRendered() && controlsState.getFastRewindEnabled()) {
            left.put(clientId + "_ds_fr", "fastrewind");
        }
        if (controlsState.getPreviousRendered() && controlsState.getPreviousEnabled()) {
            left.put(clientId + "_ds_prev", "previous");
        }
        if (controlsState.getFastForwardRendered() && controlsState.getFastForwardEnabled()) {
            right.put(clientId + "_ds_ff", "fastforward");
        }
        if (controlsState.getNextRendered() && controlsState.getNextEnabled()) {
            right.put(clientId + "_ds_next", "next");
        }
        if (controlsState.getLastRendered() && controlsState.getLastEnabled()) {
            right.put(clientId + "_ds_l", "last");
        }
        if (!left.isEmpty()) {
            controls.put("left", left);
        }
        if (!right.isEmpty()) {
            controls.put("right", right);
        }
        return controls;
    }

    public void buildScript(ResponseWriter writer, FacesContext context, UIComponent component, Map<?, ?> buttons, Map<?, ?> digitals) throws IOException {
        JSFunction function = new JSFunction("new RichFaces.ui.DataScroller", new Object[0]);
        function.addParameter((Object)component.getClientId(context));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("buttons", buttons);
        options.put("digitals", digitals);
        options.put("currentPage", (Integer)component.getAttributes().get("page"));
        function.addParameter((Object)this.getSubmitFunction(context, component));
        function.addParameter(options);
        writer.write(function.toString());
    }

    public JSFunctionDefinition getSubmitFunction(FacesContext facesContext, UIComponent component) {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[]{JSReference.EVENT, new JSReference("element"), new JSReference("data")});
        AjaxFunction function = AjaxRendererUtils.buildAjaxFunction((FacesContext)facesContext, (UIComponent)component);
        Map parameters = function.getOptions().getParameters();
        parameters.put(component.getClientId(facesContext) + ":page", new JSLiteral("data.page"));
        definition.addToBody((Object)function.toScript());
        return definition;
    }

    public void encodeFacet(FacesContext context, UIComponent component) throws IOException {
        component.encodeAll(context);
    }

    public boolean getRendersChildren() {
        return true;
    }
}

