/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.web.admin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.jsf.OperationActionBean;
import org.nuxeo.elasticsearch.web.admin.ElasticSearchManager;
import org.opentoutatice.elasticsearch.api.OttcElasticSearchAdmin;
import org.opentoutatice.elasticsearch.api.OttcElasticSearchIndexing;
import org.opentoutatice.elasticsearch.core.reindexing.docs.automation.CleanESIndices;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.exception.ReIndexingStateException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.exception.ReIndexingStatusException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.exception.ReIndexingException;

@Name(value="esAdmin")
@Scope(value=ScopeType.EVENT)
@Install(precedence=31)
public class OttcElasticSearchManager
extends ElasticSearchManager {
    @In(create=true, required=true)
    protected OperationActionBean operationActionBean;
    @In(create=true)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    private static final Log log = LogFactory.getLog(OttcElasticSearchManager.class);
    protected static final String ALIAS_MODE_LABEL = "%s (alias mode enabled - Zero Down Time)";

    public boolean isAliasModeEnabled(String repositoryName) {
        return ((OttcElasticSearchAdmin)this.esa).aliasConfigured(repositoryName);
    }

    public void startReindexAll() {
        if (!this.isAliasModeEnabled(this.getRepositoryName())) {
            super.startReindexAll();
        } else {
            log.warn((Object)String.format("Re-indexing the entire repository [%s] with ZDT", this.getRepositoryName()));
            try {
                ((OttcElasticSearchIndexing)this.esi).reIndexAllDocumentsWithZeroDownTime(this.getRepositoryName());
            }
            catch (ReIndexingStateException | ReIndexingStatusException | ReIndexingException e) {
                log.fatal((Object)"Error during ZDT full re-indexing: process aborted");
                this.facesMessages.add(StatusMessage.Severity.ERROR, "Erreur durant le processus de r\u00e9-indexation: le processus a \u00e9t\u00e9 arr\u00eat\u00e9", new Object[0]);
            }
        }
    }

    public void cleanIndices() {
        if (this.isAliasModeEnabled(this.getRepositoryName())) {
            try {
                this.operationActionBean.doOperation("Documents.CleanESIndices");
            }
            catch (Exception e) {
                log.fatal((Object)"Error during indexes cleaning: process aborted");
                this.facesMessages.add(StatusMessage.Severity.ERROR, "Erreur durant le nettoyage des index: le processus a \u00e9t\u00e9 arr\u00eat\u00e9", new Object[0]);
            }
            this.facesMessages.add(StatusMessage.Severity.INFO, "Nettoyage des index termin\u00e9", new Object[0]);
        } else {
            this.facesMessages.add(StatusMessage.Severity.WARN, "Le d\u00e9p\u00f4t n'est pas configur\u00e9 en mode alias: aucune action effectu\u00e9e", new Object[0]);
        }
    }

    public Integer numberOfOrphanIndices() {
        Integer nb = 0;
        try {
            Collection<String> orphanIndices = CleanESIndices.getOrphanIndices();
            nb = CollectionUtils.isNotEmpty(orphanIndices) ? orphanIndices.size() : nb.intValue();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Object)"Error getting EsStateChecker - check Elasticsearch cluster");
        }
        return nb;
    }

    public Map<String, String> getRepositoryNamesWithAliasMode() {
        HashMap<String, String> reposWith = new HashMap<String, String>(this.getRepositoryNames().size());
        for (String repo : this.getRepositoryNames()) {
            if (this.isAliasModeEnabled(repo)) {
                reposWith.put(String.format(ALIAS_MODE_LABEL, repo), repo);
                continue;
            }
            reposWith.put(repo, repo);
        }
        return reposWith;
    }

    public String confirm() {
        return "return confirm('Si le d\u00e9p\u00f4t n\\'est pas configur\u00e9 en Zero Down Time, les recherches Elasticsearch seront partielles durant la r\u00e9-indexation \\(rupture de service\\).\\n                                                            Confirmez-vous la r\u00e9-indexation ?');";
    }
}

